/*
 * Decompiled with CFR 0.152.
 */
package alluxio.heartbeat;

import alluxio.heartbeat.SleepIntervalSupplier;
import alluxio.shaded.client.org.apache.logging.log4j.core.util.CronExpression;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;

public class CronExpressionIntervalSupplier
implements SleepIntervalSupplier {
    private final long mInterval;
    private final CronExpression mCron;

    public CronExpressionIntervalSupplier(CronExpression cronExpression, long fixedInterval) {
        this.mInterval = fixedInterval;
        this.mCron = cronExpression;
    }

    @Override
    public long getNextInterval(long mPreviousTickedMs, long nowTimeStampMillis) {
        Date now;
        long nextInterval = 0L;
        long executionTimeMs = nowTimeStampMillis - mPreviousTickedMs;
        if (executionTimeMs < this.mInterval) {
            nextInterval = this.mInterval - executionTimeMs;
        }
        if (this.mCron.isSatisfiedBy(now = Date.from(Instant.ofEpochMilli(nowTimeStampMillis + nextInterval)))) {
            return nextInterval;
        }
        return nextInterval + Duration.between(now.toInstant(), this.mCron.getNextValidTimeAfter(now).toInstant()).toMillis();
    }

    @Override
    public long getRunLimit(long mPreviousTickedMs) {
        Date now = Date.from(Instant.ofEpochMilli(mPreviousTickedMs));
        return Duration.between(now.toInstant(), this.mCron.getNextInvalidTimeAfter(now).toInstant()).toMillis();
    }
}

