/*
 * Decompiled with CFR 0.152.
 */
package alluxio.metrics;

import alluxio.shaded.client.com.codahale.metrics.CachedGauge;
import alluxio.shaded.client.com.codahale.metrics.Metric;
import alluxio.shaded.client.com.codahale.metrics.MetricSet;
import com.sun.management.OperatingSystemMXBean;
import com.sun.management.UnixOperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class OperationSystemGaugeSet
implements MetricSet {
    @Override
    public Map<String, Metric> getMetrics() {
        UnixOperatingSystemMXBean unixb;
        OperatingSystemMXBean osmxb;
        HashMap<String, Metric> gauges = new HashMap<String, Metric>();
        try {
            osmxb = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            unixb = (UnixOperatingSystemMXBean)osmxb;
        }
        catch (Throwable e) {
            return gauges;
        }
        gauges.put("os.freePhysicalMemory", new CachedGauge<Object>(10L, TimeUnit.MINUTES){

            @Override
            protected Long loadValue() {
                return osmxb.getFreePhysicalMemorySize();
            }
        });
        gauges.put("os.totalPhysicalMemory", new CachedGauge<Long>(10L, TimeUnit.MINUTES){

            @Override
            protected Long loadValue() {
                return osmxb.getTotalPhysicalMemorySize();
            }
        });
        gauges.put("os.cpuLoad", new CachedGauge<Double>(10L, TimeUnit.MINUTES){

            @Override
            protected Double loadValue() {
                return osmxb.getSystemCpuLoad();
            }
        });
        gauges.put("os.maxFileCount", new CachedGauge<Long>(10L, TimeUnit.MINUTES){

            @Override
            protected Long loadValue() {
                return unixb.getMaxFileDescriptorCount();
            }
        });
        gauges.put("os.openFileCount", new CachedGauge<Long>(10L, TimeUnit.MINUTES){

            @Override
            protected Long loadValue() {
                return unixb.getOpenFileDescriptorCount();
            }
        });
        return gauges;
    }
}

