/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.com.amazonaws.internal;

import alluxio.shaded.client.com.amazonaws.internal.MetricAware;
import alluxio.shaded.client.com.amazonaws.internal.Releasable;
import alluxio.shaded.client.com.amazonaws.internal.SdkIOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;

public class SdkDigestInputStream
extends DigestInputStream
implements MetricAware,
Releasable {
    private static final int SKIP_BUF_SIZE = 2048;

    public SdkDigestInputStream(InputStream stream, MessageDigest digest) {
        super(stream, digest);
    }

    @Override
    public final boolean isMetricActivated() {
        if (this.in instanceof MetricAware) {
            MetricAware metricAware = (MetricAware)((Object)this.in);
            return metricAware.isMetricActivated();
        }
        return false;
    }

    @Override
    public final long skip(long n) throws IOException {
        long m3;
        int len;
        if (n <= 0L) {
            return n;
        }
        byte[] b = new byte[(int)Math.min(2048L, n)];
        for (m3 = n; m3 > 0L; m3 -= (long)len) {
            len = this.read(b, 0, (int)Math.min(m3, (long)b.length));
            if (len != -1) continue;
            return n - m3;
        }
        assert (m3 == 0L);
        return n;
    }

    @Override
    public final void release() {
        SdkIOUtils.closeQuietly(this);
        if (this.in instanceof Releasable) {
            Releasable r = (Releasable)((Object)this.in);
            r.release();
        }
    }
}

