/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import alluxio.shaded.client.com.google.common.util.concurrent.ThreadFactoryBuilder;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

@ThreadSafe
public final class ThreadFactoryUtils {
    private ThreadFactoryUtils() {
    }

    public static ThreadFactory build(String nameFormat, boolean isDaemon) {
        return new ThreadFactoryBuilder().setDaemon(isDaemon).setNameFormat(nameFormat).build();
    }

    public static ForkJoinPool.ForkJoinWorkerThreadFactory buildFjp(String nameFormat, boolean isDaemon) {
        return new AlluxioForkJoinPoolThreadFactory(nameFormat, isDaemon);
    }

    static class AlluxioForkJoinPoolThread
    extends ForkJoinWorkerThread {
        protected AlluxioForkJoinPoolThread(ForkJoinPool pool, String name, boolean isDaemon) {
            super(pool);
            this.setName(name);
            this.setDaemon(isDaemon);
        }
    }

    static class AlluxioForkJoinPoolThreadFactory
    implements ForkJoinPool.ForkJoinWorkerThreadFactory {
        private static final AtomicLong THREAD_INDEX = new AtomicLong(0L);
        private final String mNameFormat;
        private final boolean mIsDaemon;

        public AlluxioForkJoinPoolThreadFactory(String nameFormat, boolean isDaemon) {
            this.mNameFormat = nameFormat;
            this.mIsDaemon = isDaemon;
        }

        @Override
        public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
            return new AlluxioForkJoinPoolThread(pool, String.format(this.mNameFormat, THREAD_INDEX.getAndIncrement()), this.mIsDaemon);
        }
    }
}

