/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util.executor;

import alluxio.annotation.SuppressFBWarnings;
import alluxio.util.executor.ControllableQueue;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ControllableScheduler
implements ScheduledExecutorService {
    private final ControllableQueue<ScheduledTask<?>> mQueue = new ControllableQueue();

    public void jumpAndExecute(long duration, TimeUnit timeUnit) {
        long durationInMillis = TimeUnit.MILLISECONDS.convert(duration, timeUnit);
        this.mQueue.tick(durationInMillis);
        while (!this.schedulerIsIdle()) {
            this.runNextPendingCommand();
        }
    }

    public boolean schedulerIsIdle() {
        return this.mQueue.isEmpty() || this.mQueue.getHeadDelay() > 0L;
    }

    public void runNextPendingCommand() {
        long peakDelay = this.mQueue.getHeadDelay();
        ScheduledTask<?> scheduledTask = this.mQueue.pop();
        scheduledTask.run();
        if (!scheduledTask.isCancelled() && scheduledTask.isRepeat()) {
            this.mQueue.add(scheduledTask.mRepeatDelay + peakDelay, scheduledTask);
        }
    }

    @Override
    public void execute(Runnable command) {
        this.schedule(command, 0L, TimeUnit.SECONDS);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        ScheduledTask task = new ScheduledTask(command);
        this.mQueue.add(TimeUnit.MILLISECONDS.convert(delay, unit), task);
        return task;
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        ScheduledTask<V> task = new ScheduledTask<V>(callable);
        this.mQueue.add(TimeUnit.MILLISECONDS.convert(delay, unit), task);
        return task;
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.scheduleWithFixedDelay(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        ScheduledTask task = new ScheduledTask(TimeUnit.MILLISECONDS.convert(delay, unit), command);
        this.mQueue.add(TimeUnit.MILLISECONDS.convert(initialDelay, unit), task);
        return task;
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        return this.schedule(callable, 0L, TimeUnit.SECONDS);
    }

    @Override
    public Future<?> submit(Runnable command) {
        return this.submit(command, null);
    }

    @Override
    public <T> Future<T> submit(Runnable command, T result) {
        return this.submit(new RunnableToCallableAdapter<T>(command, result));
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public boolean isShutdown() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public boolean isTerminated() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public void shutdown() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public List<Runnable> shutdownNow() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @SuppressFBWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"})
    private final class ScheduledTask<T>
    implements ScheduledFuture<T>,
    Runnable {
        private final long mRepeatDelay;
        private final Callable<T> mCommand;
        private T mFutureResult;
        private Exception mFailure = null;
        private boolean mIsCancelled = false;
        private boolean mIsDone = false;

        public ScheduledTask(Callable<T> command) {
            this.mRepeatDelay = -1L;
            this.mCommand = command;
        }

        public ScheduledTask(Runnable command) {
            this(-1L, command);
        }

        public ScheduledTask(long repeatDelay, Runnable command) {
            this.mRepeatDelay = repeatDelay;
            this.mCommand = new RunnableToCallableAdapter<Object>(command, null);
        }

        public boolean isRepeat() {
            return this.mRepeatDelay >= 0L;
        }

        public String toString() {
            return this.mCommand.toString() + " mRepeatDelay=" + this.mRepeatDelay;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            throw new UnsupportedOperationException("Operation not supported");
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.mIsCancelled = true;
            return ControllableScheduler.this.mQueue.remove(this);
        }

        @Override
        public boolean isCancelled() {
            return this.mIsCancelled;
        }

        @Override
        public boolean isDone() {
            return this.mIsDone;
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            if (!this.mIsDone) {
                throw new UnsupportedOperationException("Operation not supported");
            }
            if (this.mFailure != null) {
                throw new ExecutionException(this.mFailure);
            }
            return this.mFutureResult;
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.get();
        }

        @Override
        public void run() {
            try {
                this.mFutureResult = this.mCommand.call();
            }
            catch (Exception e) {
                this.mFailure = e;
            }
            this.mIsDone = true;
        }

        @Override
        public int compareTo(Delayed o) {
            throw new UnsupportedOperationException("Operation not supported");
        }
    }

    private final class RunnableToCallableAdapter<T>
    implements Callable<T> {
        private final Runnable mRunnable;
        private final T mResult;

        RunnableToCallableAdapter(Runnable runnable, T result) {
            this.mRunnable = runnable;
            this.mResult = result;
        }

        public String toString() {
            return this.mRunnable.toString();
        }

        @Override
        public T call() throws Exception {
            this.mRunnable.run();
            return this.mResult;
        }
    }
}

