/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import alluxio.grpc.BuildVersion;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class RuntimeConstants {
    public static final String VERSION = "300";
    public static final String REVISION_SHORT;
    public static final String VERSION_AND_REVISION_SHORT;
    public static final BuildVersion UNKNOWN_VERSION_INFO;
    public static final BuildVersion CURRENT_VERSION_INFO;
    public static final String ALLUXIO_JAR = "target/alluxio-300-jar-with-dependencies.jar";
    public static final String ALLUXIO_DOCS_URL;
    public static final String ALLUXIO_JAVADOC_URL;
    public static final String ALLUXIO_DEBUG_DOCS_URL;
    public static final String ALLUXIO_2X_UPGRADE_DOC_URL;
    public static final String ALLUXIO_SECURITY_DOCS_URL;

    private RuntimeConstants() {
    }

    static {
        if (VERSION.endsWith("SNAPSHOT") || !VERSION.contains("\\.")) {
            ALLUXIO_DOCS_URL = "https://docs.alluxio.io/os/user/edge";
            ALLUXIO_JAVADOC_URL = "https://docs.alluxio.io/os/javadoc/edge";
        } else {
            String[] majorMinor = VERSION.split("\\.");
            ALLUXIO_DOCS_URL = String.format("https://docs.alluxio.io/os/user/%s.%s", majorMinor[0], majorMinor[1]);
            ALLUXIO_JAVADOC_URL = String.format("https://docs.alluxio.io/os/javadoc/%s.%s", majorMinor[0], majorMinor[1]);
        }
        REVISION_SHORT = "31d367fce972d2a6b7f17a7d4ad5d838e4aea5c8".length() > 8 ? "31d367fce972d2a6b7f17a7d4ad5d838e4aea5c8".substring(0, 8) : "31d367fce972d2a6b7f17a7d4ad5d838e4aea5c8";
        VERSION_AND_REVISION_SHORT = "300-" + REVISION_SHORT;
        UNKNOWN_VERSION_INFO = BuildVersion.newBuilder().setVersion("UNKNOWN").setRevision("UNKNOWN").build();
        CURRENT_VERSION_INFO = BuildVersion.newBuilder().setVersion(VERSION).setRevision(REVISION_SHORT).build();
        ALLUXIO_DEBUG_DOCS_URL = ALLUXIO_DOCS_URL + "/en/operation/Troubleshooting.html";
        ALLUXIO_2X_UPGRADE_DOC_URL = ALLUXIO_DOCS_URL + "/en/operation/2.x-Upgrade.html";
        ALLUXIO_SECURITY_DOCS_URL = ALLUXIO_DOCS_URL + "/en/operation/Security.html";
    }
}

