/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.block.stream;

import alluxio.client.block.stream.DefaultBlockWorkerClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.grpc.CacheRequest;
import alluxio.grpc.ClearMetricsRequest;
import alluxio.grpc.ClearMetricsResponse;
import alluxio.grpc.CompleteFilePRequest;
import alluxio.grpc.CompleteFilePResponse;
import alluxio.grpc.CopyRequest;
import alluxio.grpc.CopyResponse;
import alluxio.grpc.CreateFilePRequest;
import alluxio.grpc.CreateFilePResponse;
import alluxio.grpc.CreateLocalBlockRequest;
import alluxio.grpc.CreateLocalBlockResponse;
import alluxio.grpc.GetStatusPRequest;
import alluxio.grpc.GetStatusPResponse;
import alluxio.grpc.GrpcServerAddress;
import alluxio.grpc.ListStatusPRequest;
import alluxio.grpc.ListStatusPResponse;
import alluxio.grpc.LoadFileRequest;
import alluxio.grpc.LoadFileResponse;
import alluxio.grpc.LoadRequest;
import alluxio.grpc.LoadResponse;
import alluxio.grpc.MoveBlockRequest;
import alluxio.grpc.MoveBlockResponse;
import alluxio.grpc.MoveRequest;
import alluxio.grpc.MoveResponse;
import alluxio.grpc.OpenLocalBlockRequest;
import alluxio.grpc.OpenLocalBlockResponse;
import alluxio.grpc.ReadRequest;
import alluxio.grpc.ReadResponse;
import alluxio.grpc.RemoveBlockRequest;
import alluxio.grpc.RemoveBlockResponse;
import alluxio.grpc.WriteRequest;
import alluxio.grpc.WriteResponse;
import alluxio.security.user.UserState;
import alluxio.shaded.client.com.google.common.util.concurrent.ListenableFuture;
import alluxio.shaded.client.io.grpc.stub.StreamObserver;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;

public interface BlockWorkerClient
extends Closeable {
    public boolean isShutdown();

    public boolean isHealthy();

    public StreamObserver<WriteRequest> writeBlock(StreamObserver<WriteResponse> var1);

    public StreamObserver<ReadRequest> readBlock(StreamObserver<ReadResponse> var1);

    public ListenableFuture<Object> readBlockNoDataBack(ReadRequest var1);

    public StreamObserver<CreateLocalBlockRequest> createLocalBlock(StreamObserver<CreateLocalBlockResponse> var1);

    public StreamObserver<OpenLocalBlockRequest> openLocalBlock(StreamObserver<OpenLocalBlockResponse> var1);

    public RemoveBlockResponse removeBlock(RemoveBlockRequest var1);

    public MoveBlockResponse moveBlock(MoveBlockRequest var1);

    public ClearMetricsResponse clearMetrics(ClearMetricsRequest var1);

    public void cache(CacheRequest var1);

    public void freeWorker();

    public ListenableFuture<LoadResponse> load(LoadRequest var1);

    public ListenableFuture<LoadFileResponse> loadFile(LoadFileRequest var1);

    public GetStatusPResponse getStatus(GetStatusPRequest var1);

    public Iterator<ListStatusPResponse> listStatus(ListStatusPRequest var1);

    public ListenableFuture<CopyResponse> copy(CopyRequest var1);

    public ListenableFuture<MoveResponse> move(MoveRequest var1);

    public CreateFilePResponse createFile(CreateFilePRequest var1);

    public CompleteFilePResponse completeFile(CompleteFilePRequest var1);

    public static class Factory {
        public static BlockWorkerClient create(UserState userState, GrpcServerAddress address, AlluxioConfiguration alluxioConf) throws IOException {
            return new DefaultBlockWorkerClient(userState, address, alluxioConf);
        }
    }
}

