/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.AlluxioURI;
import alluxio.CloseableSupplier;
import alluxio.PositionReader;
import alluxio.annotation.SuppressFBWarnings;
import alluxio.client.ReadType;
import alluxio.client.file.DelegatingFileSystem;
import alluxio.client.file.DoraFileOutStream;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.URIStatus;
import alluxio.client.file.dora.DoraCacheClient;
import alluxio.client.file.dora.WorkerLocationPolicy;
import alluxio.client.file.options.OutStreamOptions;
import alluxio.client.file.ufs.UfsBaseFileSystem;
import alluxio.collections.Pair;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.exception.FileAlreadyExistsException;
import alluxio.exception.FileDoesNotExistException;
import alluxio.exception.FileIncompleteException;
import alluxio.exception.InvalidPathException;
import alluxio.exception.OpenDirectoryException;
import alluxio.exception.runtime.AlluxioRuntimeException;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.ExistsPOptions;
import alluxio.grpc.GetStatusPOptions;
import alluxio.grpc.ListStatusPOptions;
import alluxio.grpc.OpenFilePOptions;
import alluxio.grpc.RenamePOptions;
import alluxio.grpc.SetAttributePOptions;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.proto.dataserver.Protocol;
import alluxio.shaded.client.com.codahale.metrics.Counter;
import alluxio.shaded.client.com.google.common.collect.ImmutableList;
import alluxio.shaded.client.io.grpc.Status;
import alluxio.shaded.client.io.grpc.StatusRuntimeException;
import alluxio.util.FileSystemOptionsUtils;
import alluxio.util.io.PathUtils;
import alluxio.wire.BlockInfo;
import alluxio.wire.BlockLocation;
import alluxio.wire.BlockLocationInfo;
import alluxio.wire.FileBlockInfo;
import alluxio.wire.WorkerNetAddress;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
public class DoraCacheFileSystem
extends DelegatingFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(DoraCacheFileSystem.class);
    public static final int DUMMY_MOUNT_ID = 0;
    private static final Counter UFS_FALLBACK_COUNTER = MetricsSystem.counter(MetricKey.CLIENT_UFS_FALLBACK_COUNT.getName());
    public static DoraCacheFileSystemFactory sDoraCacheFileSystemFactory = new DoraCacheFileSystemFactory();
    private final DoraCacheClient mDoraClient;
    private final FileSystemContext mFsContext;
    private final boolean mMetadataCacheEnabled;
    private final long mDefaultVirtualBlockSize;

    public DoraCacheFileSystem(FileSystem fs, FileSystemContext context) {
        this(fs, context, new DoraCacheClient(context, new WorkerLocationPolicy(2000)));
    }

    protected DoraCacheFileSystem(FileSystem fs, FileSystemContext context, DoraCacheClient doraCacheClient) {
        super(fs);
        this.mDoraClient = doraCacheClient;
        this.mFsContext = context;
        this.mMetadataCacheEnabled = context.getClusterConf().getBoolean(PropertyKey.DORA_CLIENT_METADATA_CACHE_ENABLED);
        this.mDefaultVirtualBlockSize = context.getClusterConf().getBytes(PropertyKey.USER_BLOCK_SIZE_BYTES_DEFAULT);
    }

    @Override
    public URIStatus getStatus(AlluxioURI path, GetStatusPOptions options) throws IOException, AlluxioException {
        AlluxioURI ufsFullPath = this.convertAlluxioPathToUFSPath(path);
        if (!this.mMetadataCacheEnabled) {
            return this.mDelegatedFileSystem.getStatus(ufsFullPath, options);
        }
        try {
            GetStatusPOptions mergedOptions = FileSystemOptionsUtils.getStatusDefaults(this.mFsContext.getPathConf(path)).toBuilder().mergeFrom(options).build();
            return this.mDoraClient.getStatus(ufsFullPath.toString(), mergedOptions);
        }
        catch (RuntimeException ex) {
            if (ex instanceof StatusRuntimeException && ((StatusRuntimeException)ex).getStatus().getCode() == Status.NOT_FOUND.getCode()) {
                throw new FileNotFoundException();
            }
            UFS_FALLBACK_COUNTER.inc();
            LOG.debug("Dora client get status error ({} times). Fall back to UFS.", (Object)UFS_FALLBACK_COUNTER.getCount(), (Object)ex);
            return this.mDelegatedFileSystem.getStatus(ufsFullPath, options);
        }
    }

    @Override
    public FileInStream openFile(AlluxioURI path, OpenFilePOptions options) throws IOException, AlluxioException {
        return this.openFile(this.getStatus(path), options);
    }

    @Override
    public FileInStream openFile(URIStatus status, OpenFilePOptions options) throws IOException, AlluxioException {
        AlluxioURI path = new AlluxioURI(status.getPath());
        if (status.isFolder()) {
            throw new OpenDirectoryException(path);
        }
        if (!status.isCompleted()) {
            throw new FileIncompleteException(path);
        }
        AlluxioConfiguration conf = this.mFsContext.getPathConf(path);
        OpenFilePOptions mergedOptions = FileSystemOptionsUtils.openFileDefaults(conf).toBuilder().mergeFrom(options).build();
        try {
            Protocol.OpenUfsBlockOptions openUfsBlockOptions = Protocol.OpenUfsBlockOptions.newBuilder().setUfsPath(status.getUfsPath()).setOffsetInFile(0L).setBlockSize(status.getLength()).setMaxUfsReadConcurrency(mergedOptions.getMaxUfsReadConcurrency()).setNoCache(!ReadType.fromProto(mergedOptions.getReadType()).isCache()).setMountId(0L).build();
            return this.mDoraClient.getInStream(status, openUfsBlockOptions);
        }
        catch (RuntimeException ex) {
            UFS_FALLBACK_COUNTER.inc();
            LOG.debug("Dora client open file error ({} times). Fall back to UFS.", (Object)UFS_FALLBACK_COUNTER.getCount(), (Object)ex);
            return this.mDelegatedFileSystem.openFile(status, mergedOptions);
        }
    }

    @Override
    public PositionReader openPositionRead(AlluxioURI path, OpenFilePOptions options) {
        try {
            return this.openPositionRead(this.getStatus(path), options);
        }
        catch (AlluxioException | IOException e) {
            throw AlluxioRuntimeException.from(e);
        }
    }

    @Override
    public PositionReader openPositionRead(URIStatus status, OpenFilePOptions options) {
        AlluxioURI path = new AlluxioURI(status.getPath());
        if (status.isFolder()) {
            throw AlluxioRuntimeException.from(new OpenDirectoryException(path));
        }
        if (!status.isCompleted()) {
            throw AlluxioRuntimeException.from(new FileIncompleteException(path));
        }
        AlluxioConfiguration conf = this.mFsContext.getPathConf(path);
        OpenFilePOptions mergedOptions = FileSystemOptionsUtils.openFileDefaults(conf).toBuilder().mergeFrom(options).build();
        Protocol.OpenUfsBlockOptions openUfsBlockOptions = Protocol.OpenUfsBlockOptions.newBuilder().setUfsPath(status.getUfsPath()).setOffsetInFile(0L).setBlockSize(status.getLength()).setMaxUfsReadConcurrency(mergedOptions.getMaxUfsReadConcurrency()).setNoCache(!ReadType.fromProto(mergedOptions.getReadType()).isCache()).setMountId(0L).build();
        return this.mDoraClient.createNettyPositionReader(status, openUfsBlockOptions, new CloseableSupplier<PositionReader>(() -> this.mDelegatedFileSystem.openPositionRead(status, mergedOptions)));
    }

    @Override
    public List<URIStatus> listStatus(AlluxioURI path, ListStatusPOptions options) throws FileDoesNotExistException, IOException, AlluxioException {
        AlluxioURI ufsFullPath = this.convertAlluxioPathToUFSPath(path);
        ufsFullPath = new AlluxioURI(PathUtils.normalizePath(ufsFullPath.toString(), "/"));
        try {
            ListStatusPOptions mergedOptions = FileSystemOptionsUtils.listStatusDefaults(this.mFsContext.getPathConf(path)).toBuilder().mergeFrom(options).build();
            return this.mDoraClient.listStatus(ufsFullPath.toString(), mergedOptions);
        }
        catch (RuntimeException ex) {
            if (ex instanceof StatusRuntimeException && ((StatusRuntimeException)ex).getStatus().getCode() == Status.NOT_FOUND.getCode()) {
                return Collections.emptyList();
            }
            UFS_FALLBACK_COUNTER.inc();
            LOG.debug("Dora client list status error ({} times). Fall back to UFS.", (Object)UFS_FALLBACK_COUNTER.getCount(), (Object)ex);
            return this.mDelegatedFileSystem.listStatus(ufsFullPath, options);
        }
    }

    @Override
    public FileOutStream createFile(AlluxioURI alluxioPath, CreateFilePOptions options) throws FileAlreadyExistsException, InvalidPathException, IOException, AlluxioException {
        AlluxioURI ufsFullPath = this.convertAlluxioPathToUFSPath(alluxioPath);
        try {
            CreateFilePOptions mergedOptions = FileSystemOptionsUtils.createFileDefaults(this.mFsContext.getPathConf(alluxioPath)).toBuilder().mergeFrom(options).build();
            Pair<URIStatus, String> result = this.mDoraClient.createFile(ufsFullPath.toString(), mergedOptions);
            URIStatus status = result.getFirst();
            String uuid = result.getSecond();
            LOG.debug("Created file {}, options: {}", (Object)alluxioPath.getPath(), (Object)mergedOptions);
            OutStreamOptions outStreamOptions = new OutStreamOptions(mergedOptions, this.mFsContext, this.mFsContext.getPathConf(alluxioPath));
            outStreamOptions.setUfsPath(status.getUfsPath());
            outStreamOptions.setMountId(status.getMountId());
            outStreamOptions.setAcl(status.getAcl());
            FileOutStream ufsOutStream = this.mDelegatedFileSystem.createFile(ufsFullPath, options);
            DoraFileOutStream doraOutStream = this.mDoraClient.getOutStream(ufsFullPath, this.mFsContext, outStreamOptions, ufsOutStream, uuid);
            return doraOutStream;
        }
        catch (Exception e) {
            UFS_FALLBACK_COUNTER.inc();
            LOG.debug("Dora client CreateFile error ({} times). Fall back to UFS.", (Object)UFS_FALLBACK_COUNTER.getCount(), (Object)e);
            throw e;
        }
    }

    @Override
    public void createDirectory(AlluxioURI path, CreateDirectoryPOptions options) throws FileAlreadyExistsException, InvalidPathException, IOException, AlluxioException {
        AlluxioURI ufsFullPath = this.convertAlluxioPathToUFSPath(path);
        LOG.warn("Dora Client does not support create/write. This is only for test.");
        this.mDelegatedFileSystem.createDirectory(ufsFullPath, options);
    }

    @Override
    public void rename(AlluxioURI src, AlluxioURI dst, RenamePOptions options) throws FileDoesNotExistException, IOException, AlluxioException {
        AlluxioURI srcUfsFullPath = this.convertAlluxioPathToUFSPath(src);
        AlluxioURI dstUfsFullPath = this.convertAlluxioPathToUFSPath(dst);
        LOG.warn("Dora Client does not support create/write. This is only for test.");
        this.mDelegatedFileSystem.rename(srcUfsFullPath, dstUfsFullPath, options);
    }

    @Override
    public void iterateStatus(AlluxioURI path, ListStatusPOptions options, Consumer<? super URIStatus> action) throws FileDoesNotExistException, IOException, AlluxioException {
        this.listStatus(path, options).forEach(action);
    }

    @Override
    public boolean exists(AlluxioURI path, ExistsPOptions options) throws InvalidPathException, IOException, AlluxioException {
        AlluxioURI ufsFullPath = this.convertAlluxioPathToUFSPath(path);
        return this.mDelegatedFileSystem.exists(ufsFullPath, options);
    }

    @Override
    public void setAttribute(AlluxioURI path, SetAttributePOptions options) throws FileDoesNotExistException, IOException, AlluxioException {
        AlluxioURI ufsFullPath = this.convertAlluxioPathToUFSPath(path);
        LOG.warn("Dora Client does not support create/write. This is only for test.");
        this.mDelegatedFileSystem.setAttribute(ufsFullPath, options);
    }

    private AlluxioURI convertAlluxioPathToUFSPath(AlluxioURI alluxioPath) {
        if (this.mDelegatedFileSystem instanceof UfsBaseFileSystem) {
            UfsBaseFileSystem under = (UfsBaseFileSystem)this.mDelegatedFileSystem;
            AlluxioURI rootUFS = under.getRootUFS();
            try {
                if (rootUFS.isAncestorOf(alluxioPath)) {
                    return alluxioPath;
                }
            }
            catch (InvalidPathException e) {
                LOG.error("Invalid path {}", (Object)alluxioPath);
                throw new RuntimeException(e);
            }
            Object ufsFullPath = PathUtils.concatPath((Object)rootUFS, (Object)alluxioPath.toString());
            if (alluxioPath.isRoot()) {
                ufsFullPath = (String)ufsFullPath + "/";
            }
            return new AlluxioURI((String)ufsFullPath);
        }
        return alluxioPath;
    }

    @Override
    public List<BlockLocationInfo> getBlockLocations(AlluxioURI path) throws IOException, AlluxioException {
        AlluxioURI ufsPath = this.convertAlluxioPathToUFSPath(path);
        URIStatus status = this.mDoraClient.getStatus(ufsPath.toString(), FileSystemOptionsUtils.getStatusDefaults(this.mFsContext.getPathConf(path)));
        return this.getBlockLocations(status);
    }

    @Override
    public List<BlockLocationInfo> getBlockLocations(URIStatus status) throws IOException, AlluxioException {
        AlluxioURI ufsPath = this.convertAlluxioPathToUFSPath(new AlluxioURI(status.getUfsPath()));
        WorkerNetAddress workerNetAddress = this.mDoraClient.getWorkerNetAddress(ufsPath.toString());
        long blockSize = this.mDefaultVirtualBlockSize;
        long length = status.getLength();
        int blockNum = length == blockSize ? 1 : (int)(length / blockSize) + 1;
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (int i = 0; i < blockNum; ++i) {
            long offset = (long)i * blockSize;
            BlockLocation blockLocation = new BlockLocation().setWorkerAddress(workerNetAddress);
            BlockInfo bi = new BlockInfo().setBlockId(i + 1).setLength(Math.min(blockSize, status.getLength() - offset)).setLocations(ImmutableList.of(blockLocation));
            FileBlockInfo fbi = new FileBlockInfo().setUfsLocations(ImmutableList.of(ufsPath.toString())).setBlockInfo(bi).setOffset(offset);
            BlockLocationInfo blockLocationInfo = new BlockLocationInfo(fbi, ImmutableList.of(workerNetAddress));
            listBuilder.add(blockLocationInfo);
        }
        return listBuilder.build();
    }

    public static class DoraCacheFileSystemFactory {
        public DoraCacheFileSystem createAnInstance(FileSystem fs, FileSystemContext context) {
            return new DoraCacheFileSystem(fs, context);
        }
    }
}

