/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.AlluxioURI;
import alluxio.client.AlluxioStorageType;
import alluxio.client.UnderStorageType;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.dora.DoraCacheClient;
import alluxio.client.file.dora.netty.NettyDataWriter;
import alluxio.client.file.options.OutStreamOptions;
import alluxio.exception.PreconditionMessage;
import alluxio.grpc.CompleteFilePOptions;
import alluxio.grpc.FileSystemMasterCommonPOptions;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.shaded.client.com.codahale.metrics.Counter;
import alluxio.shaded.client.com.codahale.metrics.Timer;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.common.io.Closer;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.util.CommonUtils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class DoraFileOutStream
extends FileOutStream {
    private static final Logger LOG = LoggerFactory.getLogger(DoraFileOutStream.class);
    private final Closer mCloser;
    private final AlluxioStorageType mAlluxioStorageType;
    private final UnderStorageType mUnderStorageType;
    private final FileSystemContext mContext;
    private final NettyDataWriter mNettyDataWriter;
    private final FileOutStream mUnderStorageOutputStream;
    private final OutStreamOptions mOptions;
    private boolean mCanceled;
    private boolean mClosed;
    private boolean mWriteToAlluxio;
    protected final AlluxioURI mUri;
    private final DoraCacheClient mDoraClient;
    private final String mUuid;

    public DoraFileOutStream(DoraCacheClient doraClient, NettyDataWriter dataWriter, AlluxioURI path, OutStreamOptions options, FileSystemContext context, FileOutStream ufsOutStream, String uuid) throws IOException {
        this.mDoraClient = doraClient;
        this.mNettyDataWriter = dataWriter;
        this.mCloser = Closer.create();
        this.mUuid = uuid;
        this.mContext = context;
        this.mCloser.register(this.mContext.blockReinit());
        try {
            this.mUri = Preconditions.checkNotNull(path, "path");
            this.mAlluxioStorageType = options.getAlluxioStorageType();
            this.mUnderStorageType = options.getUnderStorageType();
            this.mOptions = options;
            this.mClosed = false;
            this.mCanceled = false;
            this.mWriteToAlluxio = this.mAlluxioStorageType.isStore();
            this.mBytesWritten = 0L;
            this.mUnderStorageOutputStream = this.mUnderStorageType.isSyncPersist() ? ufsOutStream : null;
        }
        catch (Throwable t) {
            throw CommonUtils.closeAndRethrow(this.mCloser, t);
        }
    }

    @Override
    public void cancel() throws IOException {
        this.mCanceled = true;
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        try (Timer.Context ctx = MetricsSystem.uniformTimer(MetricKey.CLOSE_ALLUXIO_OUTSTREAM_LATENCY.getName()).time();){
            try {
                if (this.mAlluxioStorageType.isStore()) {
                    if (this.mCanceled) {
                        this.mNettyDataWriter.cancel();
                    } else {
                        this.mNettyDataWriter.flush();
                    }
                }
            }
            catch (Exception exception) {
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            if (this.mUnderStorageType.isSyncPersist()) {
                try {
                    if (this.mCanceled) {
                        this.mUnderStorageOutputStream.cancel();
                    } else {
                        this.mUnderStorageOutputStream.flush();
                    }
                }
                catch (Exception e) {
                    LOG.error("{}", e.getCause());
                }
                finally {
                    this.mUnderStorageOutputStream.close();
                }
            }
            CompleteFilePOptions options = CompleteFilePOptions.newBuilder().setUfsLength(this.mNettyDataWriter.pos()).setCommonOptions(FileSystemMasterCommonPOptions.newBuilder().build()).setContentHash("HASH-256").build();
            this.mClosed = true;
            this.mDoraClient.completeFile(this.mUri.toString(), options, this.mUuid);
        }
        catch (Throwable e) {
            throw this.mCloser.rethrow(e);
        }
        finally {
            this.mClosed = true;
            this.mCloser.close();
        }
    }

    @Override
    public void flush() throws IOException {
        this.mNettyDataWriter.flush();
        if (this.mUnderStorageType.isSyncPersist()) {
            this.mUnderStorageOutputStream.flush();
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.writeInternal(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        Preconditions.checkArgument(b != null, (Object)PreconditionMessage.ERR_WRITE_BUFFER_NULL);
        this.writeInternal(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.writeInternal(b, off, len);
    }

    private void writeInternal(int b) throws IOException {
        if (this.mWriteToAlluxio) {
            Integer intVal = b;
            byte[] bytes = new byte[]{intVal.byteValue()};
            this.mNettyDataWriter.writeChunk(bytes, 0, 1);
            Metrics.BYTES_WRITTEN_ALLUXIO.inc();
        }
        if (this.mUnderStorageType.isSyncPersist()) {
            this.mUnderStorageOutputStream.write(b);
            Metrics.BYTES_WRITTEN_UFS.inc();
        }
        ++this.mBytesWritten;
    }

    private void writeInternal(byte[] b, int off, int len) throws IOException {
        Preconditions.checkArgument(b != null, (Object)PreconditionMessage.ERR_WRITE_BUFFER_NULL);
        Preconditions.checkArgument(off >= 0 && len >= 0 && len + off <= b.length, PreconditionMessage.ERR_BUFFER_STATE.toString(), (Object)b.length, (Object)off, (Object)len);
        if (this.mWriteToAlluxio) {
            this.mNettyDataWriter.writeChunk(b, off, len);
            Metrics.BYTES_WRITTEN_ALLUXIO.inc(len);
        }
        if (this.mUnderStorageType.isSyncPersist()) {
            this.mUnderStorageOutputStream.write(b, off, len);
            Metrics.BYTES_WRITTEN_UFS.inc(len);
        }
        this.mBytesWritten += (long)len;
    }

    @ThreadSafe
    private static final class Metrics {
        private static final Counter BYTES_WRITTEN_ALLUXIO = MetricsSystem.counter(MetricKey.CLIENT_BYTES_WRITTEN_ALLUXIO.getName());
        private static final Counter BYTES_WRITTEN_UFS = MetricsSystem.counter(MetricKey.CLIENT_BYTES_WRITTEN_UFS.getName());

        private Metrics() {
        }
    }
}

