/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.dora;

import alluxio.AlluxioURI;
import alluxio.CloseableSupplier;
import alluxio.PositionReader;
import alluxio.client.block.BlockWorkerInfo;
import alluxio.client.block.stream.BlockWorkerClient;
import alluxio.client.block.stream.GrpcDataReader;
import alluxio.client.file.DoraFileOutStream;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.PositionReadFileInStream;
import alluxio.client.file.URIStatus;
import alluxio.client.file.dora.DoraCachePositionReader;
import alluxio.client.file.dora.WorkerLocationPolicy;
import alluxio.client.file.dora.netty.NettyDataReader;
import alluxio.client.file.dora.netty.NettyDataWriter;
import alluxio.client.file.options.OutStreamOptions;
import alluxio.collections.Pair;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.PermissionDeniedException;
import alluxio.grpc.CompleteFilePOptions;
import alluxio.grpc.CompleteFilePRequest;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.CreateFilePRequest;
import alluxio.grpc.CreateFilePResponse;
import alluxio.grpc.FileInfo;
import alluxio.grpc.GetStatusPOptions;
import alluxio.grpc.GetStatusPRequest;
import alluxio.grpc.GrpcUtils;
import alluxio.grpc.ListStatusPOptions;
import alluxio.grpc.ListStatusPRequest;
import alluxio.grpc.ReadRequest;
import alluxio.grpc.RequestType;
import alluxio.proto.dataserver.Protocol;
import alluxio.resource.CloseableResource;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.wire.WorkerNetAddress;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class DoraCacheClient {
    public static final int DUMMY_BLOCK_ID = -1;
    public static final int PREFERRED_WORKER_COUNT = 1;
    private final FileSystemContext mContext;
    private final long mChunkSize;
    private final WorkerLocationPolicy mWorkerLocationPolicy;
    private final boolean mNettyTransEnabled;

    public DoraCacheClient(FileSystemContext context, WorkerLocationPolicy workerLocationPolicy) {
        this.mContext = context;
        this.mWorkerLocationPolicy = workerLocationPolicy;
        this.mChunkSize = this.mContext.getClusterConf().getBytes(PropertyKey.USER_STREAMING_READER_CHUNK_SIZE_BYTES);
        this.mNettyTransEnabled = context.getClusterConf().getBoolean(PropertyKey.USER_NETTY_DATA_TRANSMISSION_ENABLED);
    }

    public PositionReadFileInStream getInStream(URIStatus status, Protocol.OpenUfsBlockOptions ufsOptions) {
        WorkerNetAddress workerNetAddress = this.getWorkerNetAddress(status.getPath());
        if (!this.mNettyTransEnabled) {
            throw new UnsupportedOperationException("Grpc dora reader not implemented");
        }
        NettyDataReader reader = this.createNettyDataReader(workerNetAddress, ufsOptions);
        return new PositionReadFileInStream(reader, status.getLength());
    }

    public DoraFileOutStream getOutStream(AlluxioURI alluxioPath, FileSystemContext fsContext, OutStreamOptions outStreamOptions, FileOutStream ufsOutStream, String uuid) throws IOException {
        WorkerNetAddress workerNetAddress = this.getWorkerNetAddress(alluxioPath.getPath());
        NettyDataWriter writer = NettyDataWriter.create(fsContext, workerNetAddress, Long.MAX_VALUE, RequestType.ALLUXIO_BLOCK, outStreamOptions);
        return new DoraFileOutStream(this, writer, alluxioPath, outStreamOptions, fsContext, ufsOutStream, uuid);
    }

    protected long getChunkSize() {
        return this.mChunkSize;
    }

    public DoraCachePositionReader createNettyPositionReader(URIStatus status, Protocol.OpenUfsBlockOptions ufsOptions, CloseableSupplier<PositionReader> externalPositionReader) {
        WorkerNetAddress workerNetAddress = this.getWorkerNetAddress(status.getPath());
        NettyDataReader reader = this.createNettyDataReader(workerNetAddress, ufsOptions);
        return new DoraCachePositionReader(reader, status.getLength(), externalPositionReader);
    }

    protected GrpcDataReader.Factory createGrpcDataReader(WorkerNetAddress workerNetAddress, Protocol.OpenUfsBlockOptions ufsOptions) {
        ReadRequest.Builder builder = ReadRequest.newBuilder().setBlockId(-1L).setOpenUfsBlockOptions(ufsOptions).setChunkSize(this.mChunkSize);
        return new GrpcDataReader.Factory(this.mContext, workerNetAddress, builder);
    }

    protected NettyDataReader createNettyDataReader(WorkerNetAddress workerNetAddress, Protocol.OpenUfsBlockOptions ufsOptions) {
        Protocol.ReadRequest.Builder builder = Protocol.ReadRequest.newBuilder().setBlockId(-1L).setOpenUfsBlockOptions(ufsOptions).setChunkSize(this.mChunkSize);
        return new NettyDataReader(this.mContext, workerNetAddress, builder);
    }

    public List<URIStatus> listStatus(String path, ListStatusPOptions options) throws PermissionDeniedException {
        CloseableResource<BlockWorkerClient> client = this.mContext.acquireBlockWorkerClient(this.getWorkerNetAddress(path));
        try {
            ArrayList<URIStatus> result = new ArrayList<URIStatus>();
            client.get().listStatus(ListStatusPRequest.newBuilder().setPath(path).setOptions(options).build()).forEachRemaining(pListStatusResponse -> result.addAll(pListStatusResponse.getFileInfosList().stream().map(pFileInfo -> new URIStatus(GrpcUtils.fromProto(pFileInfo))).collect(Collectors.toList())));
            ArrayList<URIStatus> arrayList = result;
            if (client != null) {
                client.close();
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public URIStatus getStatus(String path, GetStatusPOptions options) throws PermissionDeniedException {
        return this.getStatusByGrpc(path, options);
    }

    protected URIStatus getStatusByGrpc(String path, GetStatusPOptions options) throws PermissionDeniedException {
        CloseableResource<BlockWorkerClient> client = this.mContext.acquireBlockWorkerClient(this.getWorkerNetAddress(path));
        try {
            GetStatusPRequest request = GetStatusPRequest.newBuilder().setPath(path).setOptions(options).build();
            FileInfo fileInfo = client.get().getStatus(request).getFileInfo();
            URIStatus uRIStatus = new URIStatus(GrpcUtils.fromProto(fileInfo));
            if (client != null) {
                client.close();
            }
            return uRIStatus;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Pair<URIStatus, String> createFile(String path, CreateFilePOptions options) {
        CloseableResource<BlockWorkerClient> client = this.mContext.acquireBlockWorkerClient(this.getWorkerNetAddress(path));
        try {
            CreateFilePRequest request = CreateFilePRequest.newBuilder().setPath(path).setOptions(options).build();
            CreateFilePResponse response = client.get().createFile(request);
            FileInfo fileInfo = response.getFileInfo();
            String uuid = response.getUuid();
            Pair<URIStatus, String> pair = new Pair<URIStatus, String>(new URIStatus(GrpcUtils.fromProto(fileInfo)), uuid);
            if (client != null) {
                client.close();
            }
            return pair;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void completeFile(String path, CompleteFilePOptions options, String uuid) {
        try (CloseableResource<BlockWorkerClient> client = this.mContext.acquireBlockWorkerClient(this.getWorkerNetAddress(path));){
            CompleteFilePRequest request = CompleteFilePRequest.newBuilder().setPath(path).setOptions(options).setUuid(uuid).build();
            client.get().completeFile(request);
            return;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public WorkerNetAddress getWorkerNetAddress(String path) {
        List<BlockWorkerInfo> workers = null;
        try {
            workers = this.mContext.getCachedWorkers();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        List<BlockWorkerInfo> preferredWorkers = this.mWorkerLocationPolicy.getPreferredWorkers(workers, path, 1);
        Preconditions.checkState(preferredWorkers.size() > 0);
        WorkerNetAddress workerNetAddress = preferredWorkers.get(0).getNetAddress();
        return workerNetAddress;
    }
}

