/*
 * Decompiled with CFR 0.152.
 */
package alluxio.grpc;

import alluxio.annotation.SuppressFBWarnings;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.GetServiceVersionPRequest;
import alluxio.grpc.GetServiceVersionPResponse;
import alluxio.grpc.NodeState;
import alluxio.grpc.ServiceType;
import alluxio.grpc.ServiceVersionClientServiceGrpc;
import alluxio.shaded.client.com.google.common.collect.ImmutableSet;
import alluxio.shaded.client.io.grpc.Status;
import alluxio.shaded.client.io.grpc.stub.StreamObserver;
import alluxio.shaded.client.javax.annotation.Nullable;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

public final class ServiceVersionClientServiceHandler
extends ServiceVersionClientServiceGrpc.ServiceVersionClientServiceImplBase {
    private final Set<ServiceType> mServices;
    @Nullable
    private final Supplier<NodeState> mNodeStateSupplier;
    private final boolean mStandbyRpcEnabled = Configuration.getBoolean(PropertyKey.STANDBY_MASTER_GRPC_ENABLED);

    public ServiceVersionClientServiceHandler(Set<ServiceType> services, @Nullable Supplier<NodeState> nodeStateSupplier) {
        this.mServices = ImmutableSet.copyOf((Collection)Objects.requireNonNull(services, "services is null"));
        this.mNodeStateSupplier = nodeStateSupplier;
    }

    @Override
    @SuppressFBWarnings(value={"DB_DUPLICATE_SWITCH_CLAUSES"})
    public void getServiceVersion(GetServiceVersionPRequest request, StreamObserver<GetServiceVersionPResponse> responseObserver) {
        long serviceVersion;
        if (!request.getAllowedOnStandbyMasters() && this.mStandbyRpcEnabled && this.mNodeStateSupplier != null && this.mNodeStateSupplier.get() == NodeState.STANDBY) {
            responseObserver.onError(Status.UNAVAILABLE.withDescription("GetServiceVersion is not supported on standby master").asException());
            return;
        }
        ServiceType serviceType = request.getServiceType();
        if (serviceType != ServiceType.UNKNOWN_SERVICE && !this.mServices.contains(serviceType)) {
            responseObserver.onError(Status.NOT_FOUND.withDescription(String.format("Service %s is not found.", serviceType.name())).asException());
            return;
        }
        switch (serviceType) {
            case FILE_SYSTEM_MASTER_CLIENT_SERVICE: {
                serviceVersion = 2L;
                break;
            }
            case FILE_SYSTEM_MASTER_WORKER_SERVICE: {
                serviceVersion = 2L;
                break;
            }
            case FILE_SYSTEM_MASTER_JOB_SERVICE: {
                serviceVersion = 2L;
                break;
            }
            case BLOCK_MASTER_CLIENT_SERVICE: {
                serviceVersion = 2L;
                break;
            }
            case BLOCK_MASTER_WORKER_SERVICE: {
                serviceVersion = 2L;
                break;
            }
            case BLOCK_WORKER_CLIENT_SERVICE: {
                serviceVersion = 1L;
                break;
            }
            case META_MASTER_CONFIG_SERVICE: {
                serviceVersion = 2L;
                break;
            }
            case META_MASTER_CLIENT_SERVICE: {
                serviceVersion = 2L;
                break;
            }
            case META_MASTER_MASTER_SERVICE: {
                serviceVersion = 1L;
                break;
            }
            case META_MASTER_PROXY_SERVICE: {
                serviceVersion = 1L;
                break;
            }
            case METRICS_MASTER_CLIENT_SERVICE: {
                serviceVersion = 2L;
                break;
            }
            case JOB_MASTER_CLIENT_SERVICE: {
                serviceVersion = 1L;
                break;
            }
            case JOB_MASTER_WORKER_SERVICE: {
                serviceVersion = 1L;
                break;
            }
            case JOB_MASTER_MASTER_SERVICE: {
                serviceVersion = 1L;
                break;
            }
            case JOURNAL_MASTER_CLIENT_SERVICE: {
                serviceVersion = 1L;
                break;
            }
            case TABLE_MASTER_CLIENT_SERVICE: {
                serviceVersion = 1L;
                break;
            }
            case RAFT_JOURNAL_SERVICE: {
                serviceVersion = 1L;
                break;
            }
            case SECURITY_SERVER_CLIENT_SERVICE: {
                serviceVersion = 1L;
                break;
            }
            case POLICY_MASTER_CLIENT_SERVICE: {
                serviceVersion = 1L;
                break;
            }
            default: {
                serviceVersion = -1L;
            }
        }
        responseObserver.onNext(GetServiceVersionPResponse.newBuilder().setVersion(serviceVersion).build());
        responseObserver.onCompleted();
    }
}

