/*
 * Decompiled with CFR 0.152.
 */
package alluxio.heartbeat;

import alluxio.heartbeat.SleepIntervalSupplier;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.helpers.NOPLogger;

public class FixedIntervalSupplier
implements SleepIntervalSupplier {
    private final long mInterval;
    protected final Logger mLogger;

    public FixedIntervalSupplier(long fixedInterval, Logger logger) {
        this.mInterval = fixedInterval;
        this.mLogger = logger;
    }

    public FixedIntervalSupplier(long fixedInterval) {
        this(fixedInterval, (Logger)NOPLogger.NOP_LOGGER);
    }

    @Override
    public long getNextInterval(long mPreviousTickedMs, long nowTimeStampMillis) {
        if (mPreviousTickedMs == -1L) {
            return -1L;
        }
        long executionTimeMs = nowTimeStampMillis - mPreviousTickedMs;
        if (executionTimeMs > this.mInterval) {
            this.mLogger.warn("{} last execution took {} ms. Longer than the interval {}", new Object[]{Thread.currentThread().getName(), executionTimeMs, this.mInterval});
            return 0L;
        }
        return this.mInterval - executionTimeMs;
    }

    @Override
    public long getRunLimit(long mPreviousTickedMs) {
        return this.mInterval;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FixedIntervalSupplier that = (FixedIntervalSupplier)o;
        return this.mInterval == that.mInterval;
    }

    public int hashCode() {
        return Objects.hash(this.mInterval);
    }
}

