/*
 * Decompiled with CFR 0.152.
 */
package alluxio.heartbeat;

import alluxio.heartbeat.HeartbeatTimer;
import alluxio.heartbeat.SleepIntervalSupplier;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import alluxio.time.Sleeper;
import alluxio.time.ThreadSleeper;
import java.time.Clock;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class SleepingTimer
implements HeartbeatTimer {
    protected long mPreviousTickedMs = -1L;
    private final String mThreadName;
    protected final Logger mLogger;
    protected final Clock mClock;
    protected final Sleeper mSleeper;
    protected final Supplier<SleepIntervalSupplier> mIntervalSupplierSupplier;
    protected volatile SleepIntervalSupplier mIntervalSupplier;

    public SleepingTimer(String threadName, Clock clock, Supplier<SleepIntervalSupplier> intervalSupplierSupplier) {
        this(threadName, LoggerFactory.getLogger(SleepingTimer.class), clock, ThreadSleeper.INSTANCE, intervalSupplierSupplier);
    }

    public SleepingTimer(String threadName, Logger logger, Clock clock, Sleeper sleeper, Supplier<SleepIntervalSupplier> intervalSupplierSupplier) {
        this.mThreadName = threadName;
        this.mLogger = logger;
        this.mClock = clock;
        this.mSleeper = sleeper;
        this.mIntervalSupplierSupplier = intervalSupplierSupplier;
        this.mIntervalSupplier = intervalSupplierSupplier.get();
    }

    @Override
    public long tick() throws InterruptedException {
        long nextInterval = this.mIntervalSupplier.getNextInterval(this.mPreviousTickedMs, this.mClock.millis());
        if (nextInterval > 0L) {
            this.mSleeper.sleep(Duration.ofMillis(nextInterval));
        }
        this.mPreviousTickedMs = this.mClock.millis();
        return this.mIntervalSupplier.getRunLimit(this.mPreviousTickedMs);
    }

    @Override
    public void update() {
        SleepIntervalSupplier newSupplier = this.mIntervalSupplierSupplier.get();
        if (!Objects.equals(this.mIntervalSupplier, newSupplier)) {
            this.mIntervalSupplier = newSupplier;
            this.mLogger.info("update {} interval supplier.", (Object)this.mThreadName);
        }
    }
}

