/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job;

import alluxio.grpc.CopyJobPOptions;
import alluxio.job.JobRequest;
import alluxio.shaded.client.com.fasterxml.jackson.annotation.JsonProperty;
import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class CopyJobRequest
implements JobRequest {
    private static final String TYPE = "copy";
    private static final long serialVersionUID = -8565405317284410500L;
    private final String mDst;
    private final CopyJobPOptions mOptions;
    private final String mSrc;

    public CopyJobRequest(@JsonProperty(value="src") String src, @JsonProperty(value="dst") String dst, @JsonProperty(value="copyJobPOptions") CopyJobPOptions options) {
        this.mSrc = Preconditions.checkNotNull(src, "The source path cannot be null");
        this.mDst = Preconditions.checkNotNull(dst, "The destination path cannot be null");
        this.mOptions = Preconditions.checkNotNull(options, "The job options cannot be null");
    }

    public String getSrc() {
        return this.mSrc;
    }

    public String getDst() {
        return this.mDst;
    }

    public CopyJobPOptions getOptions() {
        return this.mOptions;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("Src", this.mSrc).add("Dst", this.mDst).add("Options", this.mOptions).toString();
    }

    @Override
    public String getType() {
        return TYPE;
    }
}

