/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authorization;

import alluxio.collections.Pair;
import alluxio.security.authorization.AccessControlList;
import alluxio.security.authorization.AclActions;
import alluxio.security.authorization.AclEntry;
import alluxio.security.authorization.ExtendedACLEntries;
import alluxio.security.authorization.Mode;
import alluxio.shaded.client.com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.List;

public class DefaultAccessControlList
extends AccessControlList {
    private static final long serialVersionUID = 8649647787531425489L;
    public static final DefaultAccessControlList EMPTY_DEFAULT_ACL = new DefaultAccessControlList();
    private AccessControlList mAccessAcl;
    private boolean mEmpty = true;

    public DefaultAccessControlList() {
    }

    public DefaultAccessControlList(AccessControlList acl) {
        this.mAccessAcl = acl;
        this.mOwningUser = acl.mOwningUser;
        this.mOwningGroup = acl.mOwningGroup;
        this.mMode = acl.mMode;
    }

    public AccessControlList generateChildFileACL(Short umask) {
        Mode defaultMode = new Mode(umask);
        AccessControlList acl = new AccessControlList();
        acl.mOwningUser = this.mOwningUser;
        acl.mOwningGroup = this.mOwningGroup;
        acl.mMode = this.mMode;
        if (this.mExtendedEntries == null) {
            acl.mExtendedEntries = null;
            acl.mMode = Mode.and(new Mode(this.mMode), defaultMode).toShort();
        } else {
            acl.mExtendedEntries = new ExtendedACLEntries(this.mExtendedEntries);
            AclActions mask = acl.mExtendedEntries.getMask();
            AclActions groupAction = new AclActions();
            groupAction.updateByModeBits(defaultMode.getGroupBits());
            mask.mask(groupAction);
            Mode updateMode = new Mode(this.mMode);
            updateMode.setOwnerBits(updateMode.getOwnerBits().and(defaultMode.getOwnerBits()));
            updateMode.setOtherBits(updateMode.getOtherBits().and(defaultMode.getOtherBits()));
            acl.mMode = updateMode.toShort();
        }
        return acl;
    }

    public Pair<AccessControlList, DefaultAccessControlList> generateChildDirACL(Short umask) {
        AccessControlList acl = this.generateChildFileACL(umask);
        DefaultAccessControlList dAcl = new DefaultAccessControlList(acl);
        dAcl.setEmpty(false);
        dAcl.mOwningUser = this.mOwningUser;
        dAcl.mOwningGroup = this.mOwningGroup;
        dAcl.mMode = this.mMode;
        dAcl.mExtendedEntries = this.mExtendedEntries == null ? null : new ExtendedACLEntries(this.mExtendedEntries);
        return new Pair<AccessControlList, DefaultAccessControlList>(acl, dAcl);
    }

    @Override
    public void removeEntry(AclEntry entry) {
        switch (entry.getType()) {
            case NAMED_USER: 
            case NAMED_GROUP: 
            case MASK: {
                super.removeEntry(entry);
                return;
            }
            case OWNING_USER: {
                Mode modeOwner = new Mode(this.mMode);
                modeOwner.setOwnerBits(Mode.Bits.NONE);
                if (this.mAccessAcl != null) {
                    modeOwner.setOwnerBits(new Mode(this.mAccessAcl.mMode).getOwnerBits());
                }
                this.mMode = modeOwner.toShort();
                return;
            }
            case OWNING_GROUP: {
                Mode modeGroup = new Mode(this.mMode);
                modeGroup.setGroupBits(Mode.Bits.NONE);
                if (this.mAccessAcl != null) {
                    modeGroup.setGroupBits(new Mode(this.mAccessAcl.mMode).getGroupBits());
                }
                this.mMode = modeGroup.toShort();
                return;
            }
            case OTHER: {
                Mode modeOther = new Mode(this.mMode);
                modeOther.setOtherBits(Mode.Bits.NONE);
                if (this.mAccessAcl != null) {
                    modeOther.setOtherBits(new Mode(this.mAccessAcl.mMode).getOtherBits());
                }
                this.mMode = modeOther.toShort();
                return;
            }
        }
        throw new IllegalStateException("Unknown ACL entry type: " + entry.getType());
    }

    @Override
    public void setEntry(AclEntry entry) {
        if (this.isEmpty() && this.mAccessAcl != null) {
            this.mMode = this.mAccessAcl.mMode;
        }
        super.setEntry(entry);
        this.setEmpty(false);
    }

    public boolean isEmpty() {
        return this.mEmpty;
    }

    public void setEmpty(boolean empty) {
        this.mEmpty = empty;
    }

    @Override
    public List<AclEntry> getEntries() {
        if (this.isEmpty()) {
            return new ArrayList<AclEntry>();
        }
        List<AclEntry> aclEntryList = super.getEntries();
        for (AclEntry entry : aclEntryList) {
            entry.setDefault(true);
        }
        return aclEntryList;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultAccessControlList that = (DefaultAccessControlList)o;
        boolean extendedNull = this.mExtendedEntries == null && that.mExtendedEntries == null;
        boolean extendedNotNull1 = this.mExtendedEntries != null && (this.mExtendedEntries.equals(that.mExtendedEntries) || !this.mExtendedEntries.hasExtended() && that.mExtendedEntries == null);
        boolean extendedNotNull2 = that.mExtendedEntries != null && (that.mExtendedEntries.equals(this.mExtendedEntries) || !that.mExtendedEntries.hasExtended() && this.mExtendedEntries == null);
        boolean extendedEquals = extendedNull || extendedNotNull1 || extendedNotNull2;
        return this.mOwningUser.equals(that.mOwningUser) && this.mOwningGroup.equals(that.mOwningGroup) && this.mMode == that.mMode && extendedEquals && this.mEmpty == that.mEmpty;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.mOwningUser, this.mOwningGroup, this.mMode, this.mExtendedEntries, this.mEmpty);
    }
}

