/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.com.google.inject.internal;

import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.inject.Stage;
import alluxio.shaded.client.com.google.inject.internal.AbstractProcessor;
import alluxio.shaded.client.com.google.inject.internal.Errors;
import alluxio.shaded.client.com.google.inject.internal.InjectorImpl;
import alluxio.shaded.client.com.google.inject.spi.DisableCircularProxiesOption;
import alluxio.shaded.client.com.google.inject.spi.RequireAtInjectOnConstructorsOption;
import alluxio.shaded.client.com.google.inject.spi.RequireExactBindingAnnotationsOption;
import alluxio.shaded.client.com.google.inject.spi.RequireExplicitBindingsOption;

class InjectorOptionsProcessor
extends AbstractProcessor {
    private boolean disableCircularProxies = false;
    private boolean jitDisabled = false;
    private boolean atInjectRequired = false;
    private boolean exactBindingAnnotationsRequired = false;

    InjectorOptionsProcessor(Errors errors) {
        super(errors);
    }

    @Override
    public Boolean visit(DisableCircularProxiesOption option) {
        this.disableCircularProxies = true;
        return true;
    }

    @Override
    public Boolean visit(RequireExplicitBindingsOption option) {
        this.jitDisabled = true;
        return true;
    }

    @Override
    public Boolean visit(RequireAtInjectOnConstructorsOption option) {
        this.atInjectRequired = true;
        return true;
    }

    @Override
    public Boolean visit(RequireExactBindingAnnotationsOption option) {
        this.exactBindingAnnotationsRequired = true;
        return true;
    }

    InjectorImpl.InjectorOptions getOptions(Stage stage, InjectorImpl.InjectorOptions parentOptions) {
        Preconditions.checkNotNull(stage, "stage must be set");
        if (parentOptions == null) {
            return new InjectorImpl.InjectorOptions(stage, this.jitDisabled, this.disableCircularProxies, this.atInjectRequired, this.exactBindingAnnotationsRequired);
        }
        Preconditions.checkState(stage == parentOptions.stage, "child & parent stage don't match");
        return new InjectorImpl.InjectorOptions(stage, this.jitDisabled || parentOptions.jitDisabled, this.disableCircularProxies || parentOptions.disableCircularProxies, this.atInjectRequired || parentOptions.atInjectRequired, this.exactBindingAnnotationsRequired || parentOptions.exactBindingAnnotationsRequired);
    }
}

