/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.software.amazon.ionimpl;

import alluxio.shaded.client.software.amazon.ionIonCatalog;
import alluxio.shaded.client.software.amazon.ionIonDatagram;
import alluxio.shaded.client.software.amazon.ionIonStruct;
import alluxio.shaded.client.software.amazon.ionIonSymbol;
import alluxio.shaded.client.software.amazon.ionIonType;
import alluxio.shaded.client.software.amazon.ionIonValue;
import alluxio.shaded.client.software.amazon.ionSeekableReader;
import alluxio.shaded.client.software.amazon.ionSpan;
import alluxio.shaded.client.software.amazon.ionSpanProvider;
import alluxio.shaded.client.software.amazon.ionSymbolTable;
import alluxio.shaded.client.software.amazon.ionValueFactory;
import alluxio.shaded.client.software.amazon.ionimpl.DowncastingFaceted;
import alluxio.shaded.client.software.amazon.ionimpl.IonReaderTreeSystem;
import alluxio.shaded.client.software.amazon.ionimpl.PrivateReaderWriter;
import alluxio.shaded.client.software.amazon.ionimpl.PrivateUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class IonReaderTreeUserX
extends IonReaderTreeSystem
implements PrivateReaderWriter {
    ionIonCatalog _catalog;
    private int _symbol_table_top = 0;
    private ionSymbolTable[] _symbol_table_stack = new ionSymbolTable[3];

    public IonReaderTreeUserX(ionIonValue value, ionIonCatalog catalog) {
        super(value);
        this._catalog = catalog;
    }

    @Override
    public ionIonType next() {
        if (!this.next_helper_user()) {
            this._curr = null;
            return null;
        }
        this._curr = this._next;
        this._next = null;
        return this._curr.getType();
    }

    private boolean next_helper_user() {
        ionIonType next_type;
        if (this._eof) {
            return false;
        }
        if (this._next != null) {
            return true;
        }
        this.clear_system_value_stack();
        while (true) {
            next_type = this.next_helper_system();
            if (this._top != 0 || !(this._parent instanceof ionIonDatagram)) break;
            if (ionIonType.SYMBOL.equals((Object)next_type)) {
                String name;
                assert (this._next instanceof ionIonSymbol);
                ionIonSymbol sym = (ionIonSymbol)((Object)this._next);
                if (sym.isNullValue()) break;
                int sid = sym.symbolValue().getSid();
                if (sid == -1 && (name = sym.stringValue()) != null) {
                    sid = this._system.getSystemSymbolTable().findSymbol(name);
                }
                if (sid != 2 || this._next.getTypeAnnotationSymbols().length != 0) break;
                ionSymbolTable symbols = this._system.getSystemSymbolTable();
                this.set_symbol_table(symbols);
                this.push_symbol_table(symbols);
                this._next = null;
                continue;
            }
            if (!ionIonType.STRUCT.equals((Object)next_type) || !this._next.hasTypeAnnotation("$ion_symbol_table")) break;
            assert (this._next instanceof ionIonStruct);
            IonReaderTreeUserX reader = new IonReaderTreeUserX(this._next, this._catalog);
            ionSymbolTable symtab = PrivateUtils.newLocalSymtab((ionValueFactory)this._system, this._system.getSystemSymbolTable(), this._system.getCatalog(), reader, false);
            this.set_symbol_table(symtab);
            this.push_symbol_table(symtab);
            this._next = null;
        }
        return next_type != null;
    }

    private void clear_system_value_stack() {
        while (this._symbol_table_top > 0) {
            --this._symbol_table_top;
            this._symbol_table_stack[this._symbol_table_top] = null;
        }
    }

    private void push_symbol_table(ionSymbolTable symbols) {
        assert (symbols != null);
        if (this._symbol_table_top >= this._symbol_table_stack.length) {
            int new_len = this._symbol_table_stack.length * 2;
            ionSymbolTable[] temp = new ionSymbolTable[new_len];
            System.arraycopy(this._symbol_table_stack, 0, temp, 0, this._symbol_table_stack.length);
            this._symbol_table_stack = temp;
        }
        this._symbol_table_stack[this._symbol_table_top++] = symbols;
    }

    @Override
    public ionSymbolTable pop_passed_symbol_table() {
        if (this._symbol_table_top <= 0) {
            return null;
        }
        --this._symbol_table_top;
        ionSymbolTable symbols = this._symbol_table_stack[this._symbol_table_top];
        this._symbol_table_stack[this._symbol_table_top] = null;
        return symbols;
    }

    private final ionSpan currentSpanImpl() {
        if (this._curr == null) {
            throw new IllegalStateException("Reader has no current value");
        }
        TreeSpan span = new TreeSpan();
        span._value = this._curr;
        return span;
    }

    private void hoistImpl(ionSpan span) {
        if (!(span instanceof TreeSpan)) {
            throw new IllegalArgumentException("Span not appropriate for this reader");
        }
        TreeSpan treeSpan = (TreeSpan)span;
        this.re_init(treeSpan._value, true);
    }

    @Override
    public <T> T asFacet(Class<T> facetType) {
        if (facetType == ionSeekableReader.class || facetType == ionSpanProvider.class) {
            return facetType.cast(new SeekableReaderFacet());
        }
        return super.asFacet(facetType);
    }

    private class SeekableReaderFacet
    implements ionSeekableReader {
        private SeekableReaderFacet() {
        }

        public ionSpan currentSpan() {
            return IonReaderTreeUserX.this.currentSpanImpl();
        }

        public void hoist(ionSpan span) {
            IonReaderTreeUserX.this.hoistImpl(span);
        }
    }

    private static final class TreeSpan
    extends DowncastingFaceted
    implements ionSpan {
        ionIonValue _value;

        private TreeSpan() {
        }
    }
}

