/*
 * Decompiled with CFR 0.152.
 */
package alluxio.uri;

import alluxio.AlluxioURI;
import alluxio.collections.Pair;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.uri.Authority;
import alluxio.uri.MultiPartSchemeURI;
import alluxio.uri.NoAuthority;
import alluxio.uri.StandardURI;
import java.io.Serializable;
import java.net.URISyntaxException;

public interface URI
extends Comparable<URI>,
Serializable {
    public URI createNewPath(String var1, boolean var2);

    public Authority getAuthority();

    public String getPath();

    public String getQuery();

    public String getScheme();

    public String getSchemeSpecificPart();

    public boolean isAbsolute();

    public static class Factory {
        private Factory() {
        }

        public static URI create(String uriStr) {
            String path;
            int question;
            int slash;
            Preconditions.checkArgument(uriStr != null, "Can not create a uri with a null path.");
            if (AlluxioURI.hasWindowsDrive((String)uriStr, false)) {
                uriStr = "/" + (String)uriStr;
            }
            String scheme = null;
            String authority = null;
            String query = null;
            int start = 0;
            int colon = ((String)uriStr).indexOf(58);
            if (colon != -1 && (slash == -1 || colon < slash)) {
                if (slash != -1) {
                    start = slash;
                    for (slash = ((String)uriStr).indexOf(47); slash > 0 && ((String)uriStr).charAt(slash - 1) == ':'; --slash) {
                    }
                    scheme = ((String)uriStr).substring(0, slash);
                } else {
                    scheme = ((String)uriStr).substring(0, colon);
                    start = colon + 1;
                }
            }
            if (((String)uriStr).startsWith("//", start) && ((String)uriStr).length() - start > 2) {
                int nextSlash = ((String)uriStr).indexOf(47, start + 2);
                int authEnd = nextSlash > 0 ? nextSlash : ((String)uriStr).length();
                authority = ((String)uriStr).substring(start + 2, authEnd);
                start = authEnd;
            }
            if ((question = (path = ((String)uriStr).substring(start, ((String)uriStr).length())).indexOf(63)) != -1) {
                query = path.substring(question + 1);
                path = path.substring(0, question);
            }
            return Factory.create(scheme, Authority.fromString(authority), path, query);
        }

        public static URI create(String scheme, Authority authority, String path, String query) {
            Preconditions.checkArgument(path != null, "Can not create a uri with a null path.");
            Pair<String, String> schemeComponents = Factory.getSchemeComponents(scheme);
            String schemePrefix = schemeComponents.getFirst();
            scheme = schemeComponents.getSecond();
            if (scheme == null || schemePrefix.isEmpty()) {
                return new StandardURI(scheme, authority, path, query);
            }
            return new MultiPartSchemeURI(schemePrefix, scheme, authority, path, query);
        }

        public static URI create(URI parent, URI child) {
            java.net.URI childUri;
            java.net.URI parentUri;
            Object parentPath = parent.getPath();
            if (!((String)parentPath).endsWith("/") && ((String)parentPath).length() > 0) {
                parentPath = (String)parentPath + "/";
            }
            Authority authority = child.getAuthority() instanceof NoAuthority ? parent.getAuthority() : child.getAuthority();
            try {
                parentUri = new java.net.URI(Factory.getSchemeComponents(parent.getScheme()).getSecond(), null, (String)parentPath, parent.getQuery(), null);
                childUri = new java.net.URI(Factory.getSchemeComponents(child.getScheme()).getSecond(), null, child.getPath(), child.getQuery(), null);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
            java.net.URI resolved = parentUri.resolve(childUri);
            String resolvedScheme = child.getPath() == null || parent.getPath() == null || child.getScheme() != null ? child.getScheme() : parent.getScheme();
            return Factory.create(resolvedScheme, authority, resolved.getPath(), resolved.getQuery());
        }

        public static URI create(URI baseUri, String newPath, boolean checkNormalization) {
            Preconditions.checkArgument(newPath != null, "Can not create a uri with a null newPath.");
            return baseUri.createNewPath(newPath, checkNormalization);
        }

        public static Pair<String, String> getSchemeComponents(String scheme) {
            if (scheme == null) {
                return new Pair<Object, Object>(null, null);
            }
            int colon = scheme.lastIndexOf(58);
            if (colon == -1) {
                return new Pair<String, String>("", scheme);
            }
            return new Pair<String, String>(scheme.substring(0, colon), scheme.substring(colon + 1));
        }
    }
}

