/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.master.block.BlockId;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import java.security.SecureRandom;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class IdUtils {
    private static final Logger LOG = LoggerFactory.getLogger(IdUtils.class);
    public static final long INVALID_FILE_ID = -1L;
    public static final long INVALID_WORKER_ID = -1L;
    public static final long INVALID_MOUNT_ID = -1L;
    public static final long ROOT_MOUNT_ID = 1L;
    public static final long UFS_JOURNAL_MOUNT_ID = 9223372036854765807L;
    private static SecureRandom sRandom = new SecureRandom();

    private IdUtils() {
    }

    public static long createFileId(long containerId) {
        long id = BlockId.createBlockId(containerId, BlockId.getMaxSequenceNumber());
        if (id == -1L) {
            LOG.warn("Created file id -1, which is invalid");
        }
        return id;
    }

    public static long fileIdFromBlockId(long blockId) {
        return IdUtils.createFileId(BlockId.getContainerId(blockId));
    }

    public static String createRpcId() {
        return UUID.randomUUID().toString();
    }

    public static synchronized long getRandomNonNegativeLong() {
        return sRandom.nextLong() & Long.MAX_VALUE;
    }

    public static long createSessionId() {
        return IdUtils.getRandomNonNegativeLong();
    }

    public static long createMountId() {
        return IdUtils.getRandomNonNegativeLong();
    }

    public static String createFileSystemContextId() {
        return "app-" + IdUtils.getRandomNonNegativeLong();
    }

    public static String createOrGetAppIdFromConfig(AlluxioConfiguration conf) {
        if (conf.isSet(PropertyKey.USER_APP_ID)) {
            return conf.getString(PropertyKey.USER_APP_ID);
        }
        return IdUtils.createFileSystemContextId();
    }
}

