/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.common.cache.CacheBuilder;
import alluxio.shaded.client.com.google.common.cache.CacheLoader;
import alluxio.shaded.client.com.google.common.cache.LoadingCache;
import alluxio.shaded.client.com.google.common.collect.Sets;
import alluxio.shaded.client.com.google.common.util.concurrent.ExecutionError;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectSizeCalculator {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectSizeCalculator.class);
    private int mArraySize = -1;
    private final int mArrayHeaderSize;
    private final int mObjectHeaderSize;
    private final int mObjectPadding;
    private final int mReferenceSize;
    private final int mSuperClassPadding;
    private final LoadingCache<Class<?>, ClassSizeInfo> mClassInfos;
    private final Set<Object> mVisited = Sets.newIdentityHashSet();
    private final Deque<Object> mPending = new ArrayDeque<Object>(16384);
    private final Set<Class<?>> mConstantSizeClass;
    private final Map<Class<?>, Long> mClassSizeCache;
    private boolean mEstimateArray = false;
    private Set<Class<?>> mConstantClass = new HashSet();
    private long mSize;
    private int mRecursionDepth = 0;
    private static final int MAX_RECURSION = 5;

    public static long getObjectSize(Object obj) throws UnsupportedOperationException {
        return obj == null ? 0L : new ObjectSizeCalculator(CurrentLayout.SPEC).calculateObjectSize(obj);
    }

    public static long getObjectSize(Object obj, Set<Class<?>> constantClasses) throws UnsupportedOperationException {
        return obj == null ? 0L : new ObjectSizeCalculator(CurrentLayout.SPEC, constantClasses).calculateObjectSize(obj);
    }

    public ObjectSizeCalculator(MemoryLayoutSpecification memoryLayoutSpecification) {
        this(memoryLayoutSpecification, Collections.EMPTY_SET);
    }

    public ObjectSizeCalculator(MemoryLayoutSpecification memoryLayoutSpecification, Set<Class<?>> constSizeClass) {
        Preconditions.checkNotNull(memoryLayoutSpecification);
        Preconditions.checkNotNull(constSizeClass);
        this.mArrayHeaderSize = memoryLayoutSpecification.getArrayHeaderSize();
        this.mObjectHeaderSize = memoryLayoutSpecification.getObjectHeaderSize();
        this.mObjectPadding = memoryLayoutSpecification.getObjectPadding();
        this.mReferenceSize = memoryLayoutSpecification.getReferenceSize();
        this.mSuperClassPadding = memoryLayoutSpecification.getSuperclassFieldPadding();
        this.mConstantSizeClass = constSizeClass;
        if (!this.mConstantSizeClass.isEmpty()) {
            this.mEstimateArray = true;
        }
        this.mClassSizeCache = new HashMap();
        this.mClassInfos = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, ClassSizeInfo>(){

            @Override
            public ClassSizeInfo load(Class<?> clazz) {
                return new ClassSizeInfo(clazz);
            }
        });
    }

    public ObjectSizeCalculator(ObjectSizeCalculator calc) {
        this.mArrayHeaderSize = calc.mArrayHeaderSize;
        this.mObjectHeaderSize = calc.mObjectHeaderSize;
        this.mObjectPadding = calc.mObjectPadding;
        this.mReferenceSize = calc.mReferenceSize;
        this.mSuperClassPadding = calc.mSuperClassPadding;
        this.mConstantSizeClass = calc.mConstantSizeClass;
        this.mClassInfos = calc.mClassInfos;
        this.mClassSizeCache = calc.mClassSizeCache;
        this.mEstimateArray = calc.mEstimateArray;
        this.mRecursionDepth = calc.mRecursionDepth;
    }

    public synchronized long calculateObjectSize(Object obj) {
        boolean init = true;
        try {
            while (true) {
                this.visit(obj, init);
                init = false;
                if (this.mPending.isEmpty()) {
                    long l = this.mSize;
                    return l;
                }
                obj = this.mPending.removeFirst();
            }
        }
        finally {
            this.mVisited.clear();
            this.mPending.clear();
            this.mSize = 0L;
        }
    }

    private void visit(Object obj, boolean init) {
        if (obj == null || this.mVisited.contains(obj) || !init && this.mConstantClass.contains(obj.getClass())) {
            return;
        }
        Class<?> clazz = obj.getClass();
        if (clazz == ArrayElementsVisitor.class) {
            ((ArrayElementsVisitor)obj).visit(this);
        } else {
            this.mVisited.add(obj);
            if (clazz.isArray()) {
                this.visitArray(obj);
            } else {
                if (Map.class.isAssignableFrom(clazz)) {
                    this.mArraySize = ((Map)obj).size();
                }
                try {
                    this.mClassInfos.getUnchecked(clazz).visit(obj, this);
                }
                catch (ExecutionError e) {
                    if (!(e.getCause() instanceof NoClassDefFoundError)) {
                        LOG.info("Exception occurred while calculating heap size: " + e.getMessage());
                    }
                    LOG.debug("ClassNotFound Exception occurred while calculating heap size: " + e.getMessage());
                }
            }
        }
    }

    private void visitArray(Object array) {
        Class<?> componentType = array.getClass().getComponentType();
        int length = Array.getLength(array);
        if (componentType.isPrimitive()) {
            this.increaseByArraySize(length, ObjectSizeCalculator.getPrimitiveFieldSize(componentType));
        } else {
            this.increaseByArraySize(length, this.mReferenceSize);
            switch (length) {
                case 0: {
                    break;
                }
                case 1: {
                    this.enqueue(Array.get(array, 0));
                    break;
                }
                default: {
                    this.enqueue(new ArrayElementsVisitor((Object[])array, ((Object[])array).length));
                }
            }
        }
    }

    private void increaseByArraySize(int length, long elementSize) {
        this.increaseSize(ObjectSizeCalculator.roundTo((long)this.mArrayHeaderSize + (long)length * elementSize, this.mObjectPadding));
    }

    private long getClassSizeRecursive(Class<?> type, Object obj) {
        if (this.mClassSizeCache.containsKey(type)) {
            return this.mClassSizeCache.get(type);
        }
        if (this.mEstimateArray && this.mRecursionDepth < 5) {
            ObjectSizeCalculator recCalc = new ObjectSizeCalculator(this);
            ++recCalc.mRecursionDepth;
            recCalc.mConstantClass.add(type);
            if (type.getEnclosingClass() != null) {
                recCalc.mConstantClass.add(type.getEnclosingClass());
            }
            long size = recCalc.calculateObjectSize(obj);
            this.mClassSizeCache.put(type, size);
            return size;
        }
        throw new UnsupportedOperationException(type.toString() + " is not a constant size class");
    }

    void enqueue(Object obj) {
        if (obj != null) {
            this.mPending.addLast(obj);
        }
    }

    void increaseSize(long objectSize) {
        this.mSize += objectSize;
    }

    @VisibleForTesting
    static long roundTo(long x, int multiple) {
        return (x + (long)multiple - 1L) / (long)multiple * (long)multiple;
    }

    private static long getPrimitiveFieldSize(Class<?> type) {
        if (type == Boolean.TYPE || type == Byte.TYPE) {
            return 1L;
        }
        if (type == Character.TYPE || type == Short.TYPE) {
            return 2L;
        }
        if (type == Integer.TYPE || type == Float.TYPE) {
            return 4L;
        }
        if (type == Long.TYPE || type == Double.TYPE) {
            return 8L;
        }
        throw new AssertionError((Object)("Encountered unexpected primitive type " + type.getName()));
    }

    @VisibleForTesting
    static MemoryLayoutSpecification getEffectiveMemoryLayoutSpecification() {
        String vmName = System.getProperty("java.vm.name");
        if (vmName == null || !vmName.startsWith("Java HotSpot(TM) ") && !vmName.startsWith("OpenJDK")) {
            throw new UnsupportedOperationException("ObjectSizeCalculator only supported on HotSpot VM");
        }
        String dataModel = System.getProperty("sun.arch.data.model");
        if ("32".equals(dataModel)) {
            return new MemoryLayoutSpecification(){

                @Override
                public int getArrayHeaderSize() {
                    return 12;
                }

                @Override
                public int getObjectHeaderSize() {
                    return 8;
                }

                @Override
                public int getObjectPadding() {
                    return 8;
                }

                @Override
                public int getReferenceSize() {
                    return 4;
                }

                @Override
                public int getSuperclassFieldPadding() {
                    return 4;
                }
            };
        }
        if (!"64".equals(dataModel)) {
            throw new UnsupportedOperationException("Unrecognized value '" + dataModel + "' of sun.arch.data.model system property");
        }
        String strVmVersion = System.getProperty("java.vm.version");
        int vmVersion = Integer.parseInt(strVmVersion.substring(0, strVmVersion.indexOf(46)));
        if (vmVersion >= 17) {
            long maxMemory = 0L;
            for (MemoryPoolMXBean mp : ManagementFactory.getMemoryPoolMXBeans()) {
                maxMemory += mp.getUsage().getMax();
            }
            if (maxMemory < 0x780000000L) {
                return new MemoryLayoutSpecification(){

                    @Override
                    public int getArrayHeaderSize() {
                        return 16;
                    }

                    @Override
                    public int getObjectHeaderSize() {
                        return 12;
                    }

                    @Override
                    public int getObjectPadding() {
                        return 8;
                    }

                    @Override
                    public int getReferenceSize() {
                        return 4;
                    }

                    @Override
                    public int getSuperclassFieldPadding() {
                        return 4;
                    }
                };
            }
        }
        return new MemoryLayoutSpecification(){

            @Override
            public int getArrayHeaderSize() {
                return 24;
            }

            @Override
            public int getObjectHeaderSize() {
                return 16;
            }

            @Override
            public int getObjectPadding() {
                return 8;
            }

            @Override
            public int getReferenceSize() {
                return 8;
            }

            @Override
            public int getSuperclassFieldPadding() {
                return 8;
            }
        };
    }

    private class ClassSizeInfo {
        private final long mObjectSize;
        private final long mFieldSize;
        private final Field[] mReferencedFields;

        public ClassSizeInfo(Class<?> clazz) {
            long fieldsSize = 0L;
            LinkedList<Field> referenceFields = new LinkedList<Field>();
            for (Field f : clazz.getDeclaredFields()) {
                if (Modifier.isStatic(f.getModifiers())) continue;
                Class<?> type = f.getType();
                if (type.isPrimitive()) {
                    fieldsSize += ObjectSizeCalculator.getPrimitiveFieldSize(type);
                    continue;
                }
                f.setAccessible(true);
                if (f.getDeclaringClass().equals(clazz) && !f.getType().equals(clazz.getEnclosingClass())) {
                    referenceFields.add(f);
                }
                fieldsSize += (long)ObjectSizeCalculator.this.mReferenceSize;
            }
            Class<?> superClass = clazz.getSuperclass();
            if (superClass != null) {
                ClassSizeInfo superClassInfo = ObjectSizeCalculator.this.mClassInfos.getUnchecked(superClass);
                fieldsSize += ObjectSizeCalculator.roundTo(superClassInfo.mFieldSize, ObjectSizeCalculator.this.mSuperClassPadding);
                referenceFields.addAll(Arrays.asList(superClassInfo.mReferencedFields));
            }
            this.mFieldSize = fieldsSize;
            this.mObjectSize = ObjectSizeCalculator.roundTo((long)ObjectSizeCalculator.this.mObjectHeaderSize + fieldsSize, ObjectSizeCalculator.this.mObjectPadding);
            this.mReferencedFields = referenceFields.toArray(new Field[0]);
        }

        void visit(Object obj, ObjectSizeCalculator calc) {
            calc.increaseSize(this.mObjectSize);
            this.enqueueReferencedObjects(obj, calc);
        }

        public void enqueueReferencedObjects(Object obj, ObjectSizeCalculator calc) {
            for (Field f : this.mReferencedFields) {
                try {
                    if (calc.mConstantClass.contains(f.getType())) continue;
                    calc.enqueue(f.get(obj));
                }
                catch (IllegalAccessException e) {
                    AssertionError ae = new AssertionError((Object)("Unexpected denial of access to " + f));
                    ((Throwable)((Object)ae)).initCause(e);
                    throw ae;
                }
            }
        }
    }

    private static class ArrayElementsVisitor {
        private final Object[] mArray;

        ArrayElementsVisitor(Object[] array, long size) {
            this.mArray = array;
        }

        private boolean isElementConstant(ObjectSizeCalculator calc, Class<?> componentType, Object firstElement, int count) {
            Field[] fields;
            if (count < 0) {
                return false;
            }
            if (calc.mConstantSizeClass.contains(firstElement.getClass())) {
                return true;
            }
            for (Field f : fields = componentType.getDeclaredFields()) {
                Class<?> clazz = f.getType();
                if (clazz.isPrimitive() || clazz.equals(componentType) || f.getType().equals(componentType.getEnclosingClass())) continue;
                f.setAccessible(true);
                try {
                    Object obj = f.get(firstElement);
                    if (obj == null || obj.getClass().isPrimitive() || obj.getClass().equals(componentType) || calc.mConstantSizeClass.contains(obj.getClass()) || obj == firstElement || this.isElementConstant(calc, obj.getClass(), obj, count - 1)) {
                        continue;
                    }
                }
                catch (IllegalAccessException e) {
                    return false;
                }
                return false;
            }
            return true;
        }

        public void visit(ObjectSizeCalculator calc) {
            int i;
            Class<?> componentType = this.mArray.getClass().getComponentType();
            int arraySize = calc.mArraySize >= 0 ? calc.mArraySize : this.mArray.length;
            for (i = 0; i < this.mArray.length && this.mArray[i] == null; ++i) {
            }
            try {
                if (this.mArray != null && this.mArray.length != 0 && calc.mEstimateArray && i < this.mArray.length && arraySize > 10000 && this.mArray[i] != null && this.isElementConstant(calc, componentType, this.mArray[i], 5)) {
                    long size = calc.getClassSizeRecursive(componentType, this.mArray[i]);
                    calc.increaseSize((long)arraySize * size);
                    calc.mArraySize = -1;
                    return;
                }
            }
            catch (UnsupportedOperationException e) {
                LOG.info(e.getMessage());
            }
            for (Object elem : this.mArray) {
                if (elem == null) continue;
                calc.visit(elem, false);
            }
        }
    }

    private static class CurrentLayout {
        private static final MemoryLayoutSpecification SPEC = ObjectSizeCalculator.getEffectiveMemoryLayoutSpecification();

        private CurrentLayout() {
        }
    }

    public static interface MemoryLayoutSpecification {
        public int getArrayHeaderSize();

        public int getObjectHeaderSize();

        public int getObjectPadding();

        public int getReferenceSize();

        public int getSuperclassFieldPadding();
    }
}

