/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util.compression;

import alluxio.shaded.client.org.apache.commons.io.FileUtils;
import alluxio.shaded.client.org.apache.commons.io.IOUtils;
import alluxio.util.compression.DirectoryMarshaller;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class NoCompressionMarshaller
implements DirectoryMarshaller {
    private static final char DIR_CHAR = 'd';
    private static final char FILE_CHAR = 'f';

    @Override
    public long write(Path path, OutputStream outputStream) throws IOException, InterruptedException {
        long totalBytesCopied = 0L;
        try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);
             DataOutputStream dataOS = new DataOutputStream(outputStream);){
            for (Path subpath : stream.collect(Collectors.toList())) {
                byte[] relativePath = path.relativize(subpath).toString().getBytes();
                dataOS.write(relativePath.length);
                dataOS.write(relativePath);
                if (subpath.toFile().isDirectory()) {
                    dataOS.writeChar(100);
                    continue;
                }
                dataOS.writeChar(102);
                dataOS.writeLong(FileUtils.sizeOf(subpath.toFile()));
                try (BufferedInputStream fileIn = new BufferedInputStream(Files.newInputStream(subpath, new OpenOption[0]));){
                    totalBytesCopied += IOUtils.copyLarge(fileIn, dataOS);
                }
            }
        }
        return totalBytesCopied;
    }

    @Override
    public long read(Path path, InputStream inputStream) throws IOException {
        path.toFile().mkdirs();
        long totalBytesRead = 0L;
        try (DataInputStream dataIS = new DataInputStream(inputStream);){
            int pathSize;
            while ((pathSize = dataIS.read()) != -1) {
                byte[] relativePath = new byte[pathSize];
                dataIS.read(relativePath);
                File filePath = new File(path.toFile(), new String(relativePath));
                char c = dataIS.readChar();
                if (c == 'd') {
                    filePath.mkdirs();
                    continue;
                }
                filePath.getParentFile().mkdirs();
                long fileSize = dataIS.readLong();
                try (BufferedOutputStream fileOut = new BufferedOutputStream(Files.newOutputStream(filePath.toPath(), new OpenOption[0]));){
                    totalBytesRead += IOUtils.copyLarge(dataIS, fileOut, 0L, fileSize);
                }
            }
        }
        return totalBytesRead;
    }
}

