/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block.io;

import alluxio.exception.runtime.InternalRuntimeException;
import alluxio.exception.runtime.NotFoundRuntimeException;
import alluxio.network.protocol.databuffer.DataBuffer;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.common.io.Closer;
import alluxio.shaded.client.io.netty.buffer.ByteBuf;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import alluxio.util.io.BufferUtils;
import alluxio.worker.block.io.BlockWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class LocalFileBlockWriter
extends BlockWriter {
    private static final Logger LOG = LoggerFactory.getLogger(LocalFileBlockWriter.class);
    private final FileChannel mLocalFileChannel;
    private final Closer mCloser = Closer.create();
    private long mPosition;
    private boolean mClosed;

    public LocalFileBlockWriter(String path) {
        RandomAccessFile localFile;
        String filePath = Preconditions.checkNotNull(path, "path");
        try {
            localFile = this.mCloser.register(new RandomAccessFile(filePath, "rw"));
        }
        catch (FileNotFoundException e) {
            throw new NotFoundRuntimeException("wrong path when creating RandomAccessFile", e);
        }
        this.mLocalFileChannel = this.mCloser.register(localFile.getChannel());
    }

    @Override
    public long append(ByteBuffer inputBuf) {
        MappedByteBuffer outputBuf;
        int inputBufLength = inputBuf.limit() - inputBuf.position();
        try {
            outputBuf = this.mLocalFileChannel.map(FileChannel.MapMode.READ_WRITE, this.mLocalFileChannel.size(), inputBufLength);
        }
        catch (IOException e) {
            throw new InternalRuntimeException(e);
        }
        outputBuf.put(inputBuf);
        int bytesWritten1 = outputBuf.limit();
        BufferUtils.cleanDirectBuffer(outputBuf);
        long bytesWritten = bytesWritten1;
        this.mPosition += bytesWritten;
        return bytesWritten;
    }

    @Override
    public long append(ByteBuf buf) throws IOException {
        long bytesWritten = buf.readBytes(this.mLocalFileChannel, buf.readableBytes());
        this.mPosition += bytesWritten;
        return bytesWritten;
    }

    @Override
    public long append(DataBuffer buffer) throws IOException {
        ByteBuf bytebuf = null;
        try {
            bytebuf = (ByteBuf)buffer.getNettyOutput();
        }
        catch (Throwable e) {
            LOG.debug("Failed to get ByteBuf from DataBuffer, write performance may be degraded.");
        }
        if (bytebuf != null) {
            return this.append(bytebuf);
        }
        long bytesWritten = this.write(this.mLocalFileChannel.size(), buffer);
        this.mPosition += bytesWritten;
        return bytesWritten;
    }

    @Override
    public long getPosition() {
        return this.mPosition;
    }

    @Override
    public WritableByteChannel getChannel() {
        return this.mLocalFileChannel;
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.mClosed = true;
        super.close();
        this.mCloser.close();
        this.mPosition = -1L;
    }

    private long write(long offset, DataBuffer inputBuf) throws IOException {
        int inputBufLength = inputBuf.readableBytes();
        MappedByteBuffer outputBuf = this.mLocalFileChannel.map(FileChannel.MapMode.READ_WRITE, offset, inputBufLength);
        inputBuf.readBytes(outputBuf);
        int bytesWritten = outputBuf.limit();
        BufferUtils.cleanDirectBuffer(outputBuf);
        return bytesWritten;
    }

    @Override
    public void commitFile() {
        throw new UnsupportedOperationException("commitFile method is unsupported. ");
    }
}

