/*
 * Copyright 2021 The Netty Project
 *
 * The Netty Project licenses this file to you under the Apache License,
 * version 2.0 (the "License"); you may not use this file except in alluxio.shaded.client.com.liance
 * with the License. You may obtain a copy of the License at:
 *
 *   https://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */
package alluxio.shaded.client.io.netty.handler.codec.alluxio.shaded.client.com.ression;

import alluxio.shaded.client.io.netty.util.internal.ObjectUtil;

/**
 * {@link DeflateOptions} holds {@link #alluxio.shaded.client.com.ressionLevel()},
 * {@link #memLevel()} and {@link #windowBits()} for Deflate alluxio.shaded.client.com.ression.
 */
public class DeflateOptions implements CompressionOptions {

    private final int alluxio.shaded.client.com.ressionLevel;
    private final int windowBits;
    private final int memLevel;

    /**
     * @see StandardCompressionOptions#deflate()
     */
    static final DeflateOptions DEFAULT = new DeflateOptions(
            6, 15, 8
    );

    /**
     * @see StandardCompressionOptions#deflate(int, int, int)
     */
    DeflateOptions(int alluxio.shaded.client.com.ressionLevel, int windowBits, int memLevel) {
        this.alluxio.shaded.client.com.ressionLevel = ObjectUtil.checkInRange(alluxio.shaded.client.com.ressionLevel, 0, 9, "alluxio.shaded.client.com.ressionLevel");
        this.windowBits = ObjectUtil.checkInRange(windowBits, 9, 15, "windowBits");
        this.memLevel = ObjectUtil.checkInRange(memLevel, 1, 9, "memLevel");
    }

    public int alluxio.shaded.client.com.ressionLevel() {
        return alluxio.shaded.client.com.ressionLevel;
    }

    public int windowBits() {
        return windowBits;
    }

    public int memLevel() {
        return memLevel;
    }
}
