/*
 * Decompiled with CFR 0.152.
 */
package alluxio.check;

import alluxio.exception.runtime.FailedPreconditionRuntimeException;
import alluxio.shaded.client.com.amazonaws.util.EC2MetadataUtils;
import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.com.google.common.base.Joiner;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.shaded.client.org.apache.http.HttpResponse;
import alluxio.shaded.client.org.apache.http.client.config.RequestConfig;
import alluxio.shaded.client.org.apache.http.client.methods.HttpGet;
import alluxio.shaded.client.org.apache.http.impl.client.CloseableHttpClient;
import alluxio.shaded.client.org.apache.http.impl.client.HttpClientBuilder;
import alluxio.shaded.client.org.apache.http.util.EntityUtils;
import alluxio.util.EnvironmentUtils;
import alluxio.util.FeatureUtils;
import alluxio.util.OSUtils;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

@ThreadSafe
public final class UpdateCheck {
    public static final String USER_AGENT_SEPARATOR = ";";
    static final String PRODUCT_CODE_FORMAT = "ProductCode:%s";
    static final String OS_FORMAT = "OS:%s";
    static final String CFT_KEY = "cft";
    static final String DOCKER_KEY = "docker";
    static final String EC2_KEY = "ec2";
    static final String EMBEDDED_KEY = "embedded";
    static final String EMR_KEY = "emr";
    static final String GCE_KEY = "gce";
    static final String KUBERNETES_KEY = "kubernetes";
    static final String BACKUP_DELEGATION_KEY = "backupDelegation";
    static final String DAILY_BACKUP_KEY = "dailyBackup";
    static final String MASTER_AUDIT_LOG_KEY = "masterAuditLog";
    static final String PERSIST_BLACK_LIST_KEY = "persistBlackList";
    static final String PAGE_STORE_KEY = "pageStore";
    static final String INODE_METASTORE_ROCKS_KEY = "inodeRocks";
    static final String BLOCK_METASTORE_ROCKS_KEY = "blockRocks";
    static final String UNSAFE_PERSIST_KEY = "unsafePersist";
    static final String ZOOKEEPER_KEY = "zookeeper";

    public static String getLatestVersion(String id, List<String> additionalInfo, long connectionRequestTimeout, long connectTimeout, long socketTimeout) throws IOException {
        Preconditions.checkState(id != null && !id.isEmpty(), "id should not be null or empty");
        Preconditions.checkNotNull(additionalInfo);
        Joiner joiner = Joiner.on("/");
        String path = joiner.join("v0", "version", new Object[0]);
        String url = new URL(new URL("https://diagnostics.alluxio.io"), path).toString();
        HttpGet post = new HttpGet(url);
        post.setHeader("User-Agent", UpdateCheck.getUserAgentString(id, additionalInfo));
        post.setHeader("Authorization", "Basic YWxsdXhpbzp0YWNoeW9u");
        CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout((int)connectionRequestTimeout).setConnectTimeout((int)connectTimeout).setSocketTimeout((int)socketTimeout).build()).build();
        HttpResponse response = client.execute(post);
        int responseCode = response.getStatusLine().getStatusCode();
        if (responseCode != 200) {
            throw new FailedPreconditionRuntimeException("Update check request failed with code: " + responseCode);
        }
        return EntityUtils.toString(response.getEntity(), "UTF-8");
    }

    @VisibleForTesting
    public static String getUserAgentString(String id, List<String> additionalInfo) {
        ArrayList<String> info = new ArrayList<String>();
        info.add(id);
        UpdateCheck.addUserAgentEnvironments(info);
        UpdateCheck.addUserAgentFeatures(info);
        info.addAll(additionalInfo);
        return String.format("Alluxio/%s (%s)", "301", Joiner.on("; ").skipNulls().join(info));
    }

    @VisibleForTesting
    public static void addUserAgentEnvironments(List<String> info) {
        info.add(String.format(OS_FORMAT, OSUtils.OS_NAME));
        if (EnvironmentUtils.isDocker()) {
            info.add(DOCKER_KEY);
        }
        if (EnvironmentUtils.isKubernetes()) {
            info.add(KUBERNETES_KEY);
        }
        if (EnvironmentUtils.isGoogleComputeEngine()) {
            info.add(GCE_KEY);
        } else {
            UpdateCheck.addEC2Info(info);
        }
    }

    @VisibleForTesting
    public static void addUserAgentFeatures(List<String> info) {
        UpdateCheck.addIfTrue(FeatureUtils.isEmbeddedJournal(), info, EMBEDDED_KEY);
        UpdateCheck.addIfTrue(FeatureUtils.isInodeStoreRocks(), info, INODE_METASTORE_ROCKS_KEY);
        UpdateCheck.addIfTrue(FeatureUtils.isBlockStoreRocks(), info, BLOCK_METASTORE_ROCKS_KEY);
        UpdateCheck.addIfTrue(FeatureUtils.isZookeeperEnabled(), info, ZOOKEEPER_KEY);
        UpdateCheck.addIfTrue(FeatureUtils.isBackupDelegationEnabled(), info, BACKUP_DELEGATION_KEY);
        UpdateCheck.addIfTrue(FeatureUtils.isDailyBackupEnabled(), info, DAILY_BACKUP_KEY);
        UpdateCheck.addIfTrue(!FeatureUtils.isPersistenceBlacklistEmpty(), info, PERSIST_BLACK_LIST_KEY);
        UpdateCheck.addIfTrue(FeatureUtils.isUnsafeDirectPersistEnabled(), info, UNSAFE_PERSIST_KEY);
        UpdateCheck.addIfTrue(FeatureUtils.isMasterAuditLoggingEnabled(), info, MASTER_AUDIT_LOG_KEY);
        UpdateCheck.addIfTrue(FeatureUtils.isPageStoreEnabled(), info, PAGE_STORE_KEY);
    }

    public static void addIfTrue(boolean valid, List<String> features, String featureName) {
        if (valid) {
            features.add(featureName);
        }
    }

    private static void addEC2Info(List<String> info) {
        boolean isEC2 = false;
        String productCode = EnvironmentUtils.getEC2ProductCode();
        if (!productCode.isEmpty()) {
            info.add(String.format(PRODUCT_CODE_FORMAT, productCode));
            isEC2 = true;
        }
        String userData = "";
        try {
            userData = EC2MetadataUtils.getUserData();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (userData != null && !userData.isEmpty()) {
            isEC2 = true;
            if (EnvironmentUtils.isCFT(userData)) {
                info.add(CFT_KEY);
            } else if (EnvironmentUtils.isEMR(userData)) {
                info.add(EMR_KEY);
            }
        } else if (!isEC2 && EnvironmentUtils.isEC2()) {
            isEC2 = true;
        }
        if (isEC2) {
            info.add(EC2_KEY);
        }
    }

    private UpdateCheck() {
    }
}

