/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.com.github.oxo42.stateless4j.triggers;

import alluxio.shaded.client.com.github.oxo42.stateless4j.conversion.ParameterConversion;

public abstract class TriggerWithParameters<TTrigger> {
    private final TTrigger underlyingTrigger;
    private final Class<?>[] argumentTypes;

    public TriggerWithParameters(TTrigger underlyingTrigger, Class<?> ... argumentTypes) {
        assert (argumentTypes != null) : "argumentTypes is null";
        this.underlyingTrigger = underlyingTrigger;
        this.argumentTypes = argumentTypes;
    }

    public TTrigger getTrigger() {
        return this.underlyingTrigger;
    }

    public void validateParameters(Object[] args) {
        assert (args != null) : "args is null";
        ParameterConversion.validate(args, this.argumentTypes);
    }

    public String toString() {
        return TriggerWithParameters.toString(this.underlyingTrigger, this.argumentTypes);
    }

    public static <TTrigger> String toString(TTrigger trigger, Object ... args) {
        if (args == null || args.length == 0) {
            return trigger.toString();
        }
        StringBuilder b = new StringBuilder(trigger.toString());
        b.append('(');
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof Class) {
                b.append(((Class)args[i]).getSimpleName());
            } else if (args[i] != null) {
                b.append(args[i]);
            } else {
                b.append("null");
            }
            if (i >= args.length - 1) continue;
            b.append(',');
        }
        b.append(')');
        return b.toString();
    }
}

