/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.com.google.inject.internal;

import alluxio.shaded.client.com.google.common.collect.ImmutableList;
import alluxio.shaded.client.com.google.common.collect.ImmutableSet;
import alluxio.shaded.client.com.google.common.primitives.Primitives;
import alluxio.shaded.client.com.google.inject.Binding;
import alluxio.shaded.client.com.google.inject.Injector;
import alluxio.shaded.client.com.google.inject.Key;
import alluxio.shaded.client.com.google.inject.TypeLiteral;
import alluxio.shaded.client.com.google.inject.internal.GuiceInternal;
import alluxio.shaded.client.com.google.inject.internal.Messages;
import alluxio.shaded.client.com.google.inject.internal.SourceFormatter;
import alluxio.shaded.client.com.google.inject.spi.BindingSourceRestriction;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Map;

final class MissingImplementationErrorHints {
    private static final int MAX_MATCHING_TYPES_REPORTED = 3;
    private static final int MAX_RELATED_TYPES_REPORTED = 3;
    private static final ImmutableSet<Class<?>> COMMON_AMBIGUOUS_TYPES = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(Object.class)).add(String.class)).addAll(Primitives.allWrapperTypes())).build();

    private MissingImplementationErrorHints() {
    }

    static <T> ImmutableList<String> getSuggestions(Key<T> key, Injector injector) {
        ImmutableList.Builder suggestions = ImmutableList.builder();
        TypeLiteral<T> type = key.getTypeLiteral();
        BindingSourceRestriction.getMissingImplementationSuggestion(GuiceInternal.GUICE_INTERNAL, key).ifPresent(suggestions::add);
        ArrayList<String> possibleMatches = new ArrayList<String>();
        List<Binding<T>> sameTypes = injector.findBindingsByType(type);
        if (!sameTypes.isEmpty()) {
            suggestions.add("%nDid you mean?");
            int howMany = Math.min(sameTypes.size(), 3);
            for (int i = 0; i < howMany; ++i) {
                suggestions.add(Messages.format("%n    * %s", sameTypes.get(i).getKey()));
            }
            int remaining = sameTypes.size() - 3;
            if (remaining > 0) {
                String plural = remaining == 1 ? "" : "s";
                suggestions.add(Messages.format("%n    %d more binding%s with other annotations.", remaining, plural));
            }
            suggestions.add("%n");
        } else {
            String want = type.toString();
            Map<Key<?>, Binding<?>> bindingMap = injector.getAllBindings();
            for (Key<?> bindingKey : bindingMap.keySet()) {
                String have = bindingKey.getTypeLiteral().toString();
                if (!have.contains(want) && !want.contains(have)) continue;
                Formatter fmt = new Formatter();
                fmt.format("%s bound ", Messages.convert(bindingKey));
                new SourceFormatter(bindingMap.get(bindingKey).getSource(), fmt, false).format();
                possibleMatches.add(fmt.toString());
                if (possibleMatches.size() <= 3) continue;
                break;
            }
            if (!possibleMatches.isEmpty() && possibleMatches.size() <= 3) {
                suggestions.add("%nDid you mean?");
                for (String possibleMatch : possibleMatches) {
                    suggestions.add(Messages.format("%n    %s", possibleMatch));
                }
            }
        }
        if (sameTypes.isEmpty() && possibleMatches.isEmpty() && key.getAnnotationType() == null && COMMON_AMBIGUOUS_TYPES.contains(key.getTypeLiteral().getRawType())) {
            suggestions.add("%nThe key seems very generic, did you forget an annotation?");
        }
        return suggestions.build();
    }
}

