/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.software.amazon.ionimpl.lite;

import alluxio.shaded.client.software.amazon.ionDecimal;
import alluxio.shaded.client.software.amazon.ionIonFloat;
import alluxio.shaded.client.software.amazon.ionIonType;
import alluxio.shaded.client.software.amazon.ionIonWriter;
import alluxio.shaded.client.software.amazon.ionNullValueException;
import alluxio.shaded.client.software.amazon.ionValueVisitor;
import alluxio.shaded.client.software.amazon.ionimpl.PrivateIonValue;
import alluxio.shaded.client.software.amazon.ionimpl.lite.ContainerlessContext;
import alluxio.shaded.client.software.amazon.ionimpl.lite.IonContext;
import alluxio.shaded.client.software.amazon.ionimpl.lite.IonValueLite;
import java.io.IOException;
import java.math.BigDecimal;

final class IonFloatLite
extends IonValueLite
implements ionIonFloat {
    private static final int HASH_SIGNATURE = ionIonType.FLOAT.toString().hashCode();
    private Double _float_value;

    IonFloatLite(ContainerlessContext context, boolean isNull) {
        super(context, isNull);
    }

    IonFloatLite(IonFloatLite existing, IonContext context) {
        super(existing, context);
        this._float_value = existing._float_value;
    }

    IonFloatLite clone(IonContext context) {
        return new IonFloatLite(this, context);
    }

    public IonFloatLite clone() {
        return this.clone(ContainerlessContext.wrap(this.getSystem()));
    }

    int hashCode(PrivateIonValue.SymbolTableProvider symbolTableProvider) {
        int result = HASH_SIGNATURE;
        if (!this.isNullValue()) {
            long bits = Double.doubleToLongBits(this.doubleValue());
            result ^= (int)(bits >>> 32 ^ bits);
        }
        return this.hashTypeAnnotations(result, symbolTableProvider);
    }

    public ionIonType getType() {
        return ionIonType.FLOAT;
    }

    public float floatValue() throws ionNullValueException {
        this.validateThisNotNull();
        return this._float_value.floatValue();
    }

    public double doubleValue() throws ionNullValueException {
        this.validateThisNotNull();
        return this._float_value;
    }

    public BigDecimal bigDecimalValue() throws ionNullValueException {
        if (this.isNullValue()) {
            return null;
        }
        return ionDecimal.valueOf(this._float_value);
    }

    public void setValue(float value) {
        this.setValue(new Double(value));
    }

    public void setValue(double value) {
        this.setValue(new Double(value));
    }

    public void setValue(BigDecimal value) {
        this.checkForLock();
        if (value == null) {
            this._float_value = null;
            this._isNullValue(true);
        } else {
            this.setValue(value.doubleValue());
        }
    }

    public void setValue(Double d) {
        this.checkForLock();
        this._float_value = d;
        this._isNullValue(d == null);
    }

    final void writeBodyTo(ionIonWriter writer, PrivateIonValue.SymbolTableProvider symbolTableProvider) throws IOException {
        if (this.isNullValue()) {
            writer.writeNull(ionIonType.FLOAT);
        } else {
            writer.writeFloat(this._float_value);
        }
    }

    public boolean isNumericValue() {
        return !this.isNullValue() && !this._float_value.isNaN() && !this._float_value.isInfinite();
    }

    public void accept(ionValueVisitor visitor) throws Exception {
        visitor.visit(this);
    }
}

