/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.dora;

import alluxio.grpc.FileInfo;
import alluxio.shaded.client.javax.annotation.Nullable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;

public class OpenFileHandle {
    private final String mPath;
    private final FileInfo mInfo;
    private final UUID mUUID;
    private long mPos;
    private long mLastAccessTimeMs;
    private OutputStream mOutStream;
    private boolean mClosed;

    public OpenFileHandle(String path, FileInfo info, @Nullable OutputStream outStream) {
        this.mPath = path;
        this.mInfo = info;
        this.mUUID = UUID.randomUUID();
        this.mOutStream = outStream;
        this.mPos = 0L;
        this.mLastAccessTimeMs = System.currentTimeMillis();
        this.mClosed = false;
    }

    public UUID getUUID() {
        return this.mUUID;
    }

    public long getLastAccessTimeMs() {
        return this.mLastAccessTimeMs;
    }

    public String getPath() {
        return this.mPath;
    }

    public FileInfo getInfo() {
        return this.mInfo;
    }

    public long getPos() {
        return this.mPos;
    }

    public OutputStream getOutStream() {
        return this.mOutStream;
    }

    public boolean isClosed() {
        return this.mClosed;
    }

    public void close() {
        this.mClosed = true;
        if (this.mOutStream != null) {
            try {
                this.mOutStream.close();
                this.mOutStream = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

