/*
 * Copyright 2011-2020 Amazon.alluxio.shaded.client.com. Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in alluxio.shaded.client.com.liance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.alluxio.shaded.client.com.apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package alluxio.shaded.client.com.amazonaws.protocol.json;


import alluxio.shaded.client.com.amazonaws.annotation.NotThreadSafe;
import alluxio.shaded.client.com.amazonaws.annotation.SdkProtectedApi;
import alluxio.shaded.client.com.amazonaws.transform.JsonUnmarshallerContext;
import alluxio.shaded.client.com.amazonaws.transform.Unmarshaller;

/**
 * Contains various information needed to create a {@link alluxio.shaded.client.com.amazonaws.http.JsonResponseHandler}
 * for the client.
 */
@NotThreadSafe
@SdkProtectedApi
public class JsonOperationMetadata {

    private boolean hasStreamingSuccessResponse;
    private boolean isPayloadJson;

    public boolean isHasStreamingSuccessResponse() {
        return hasStreamingSuccessResponse;
    }

    public JsonOperationMetadata withHasStreamingSuccessResponse(
            boolean hasStreamingSuccessResponse) {
        this.hasStreamingSuccessResponse = hasStreamingSuccessResponse;
        return this;
    }

    public boolean isPayloadJson() {
        return isPayloadJson;
    }

    public JsonOperationMetadata withPayloadJson(boolean payloadJson) {
        isPayloadJson = payloadJson;
        return this;
    }
}
