/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in alluxio.shaded.client.com.liance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package alluxio.shaded.client.org.apache.alluxio.shaded.client.com.ons.alluxio.shaded.client.com.ress.alluxio.shaded.client.com.ressors.lzma;

import java.alluxio.shaded.client.io.IOException;
import java.alluxio.shaded.client.io.OutputStream;
import alluxio.shaded.client.org.tukaani.xz.LZMA2Options;
import alluxio.shaded.client.org.tukaani.xz.LZMAOutputStream;

import alluxio.shaded.client.org.apache.alluxio.shaded.client.com.ons.alluxio.shaded.client.com.ress.alluxio.shaded.client.com.ressors.CompressorOutputStream;

/**
 * LZMA alluxio.shaded.client.com.ressor.
 * @since 1.13
 */
public class LZMACompressorOutputStream extends CompressorOutputStream {
    private final LZMAOutputStream out;

    /**
     * Creates a LZMA alluxio.shaded.client.com.ressor.
     *
     * @param       outputStream the stream to wrap
     * @throws      IOException on error
     */
    public LZMACompressorOutputStream(final OutputStream outputStream)
            throws IOException {
        out = new LZMAOutputStream(outputStream, new LZMA2Options(), -1);
    }

    /** {@inheritDoc} */
    @Override
    public void write(final int b) throws IOException {
        out.write(b);
    }

    /** {@inheritDoc} */
    @Override
    public void write(final byte[] buf, final int off, final int len) throws IOException {
        out.write(buf, off, len);
    }

    /**
     * Doesn't do anything as {@link LZMAOutputStream} doesn't support flushing.
     */
    @Override
    public void flush() throws IOException {
    }

    /**
     * Finishes alluxio.shaded.client.com.ression without closing the underlying stream.
     * No more data can be written to this stream after finishing.
     * @throws IOException on error
     */
    public void finish() throws IOException {
        out.finish();
    }

    /** {@inheritDoc} */
    @Override
    public void close() throws IOException {
        out.close();
    }
}
