/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.conf.path.PathConfiguration;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.grpc.GetConfigurationPResponse;
import alluxio.grpc.Scope;
import alluxio.security.user.UserState;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Objects;
import javax.security.auth.Subject;

public class ClientContext {
    private volatile AlluxioConfiguration mClusterConf;
    private volatile String mClusterConfHash;
    private volatile PathConfiguration mPathConf = PathConfiguration.create(new HashMap<String, AlluxioConfiguration>());
    private volatile UserState mUserState;
    private volatile String mPathConfHash;
    private volatile boolean mIsPathConfLoaded = false;
    private volatile boolean mUriValidationEnabled = true;

    public static ClientContext create(Subject subject, AlluxioConfiguration alluxioConf) {
        return new ClientContext(subject, alluxioConf);
    }

    public static ClientContext create(AlluxioConfiguration alluxioConf) {
        return new ClientContext(new Subject(), alluxioConf);
    }

    public static ClientContext create() {
        return new ClientContext(new Subject(), Configuration.global());
    }

    protected ClientContext(ClientContext ctx) {
        this.mClusterConf = ctx.getClusterConf();
        this.mPathConf = ctx.getPathConf();
        this.mUserState = ctx.getUserState();
        this.mClusterConfHash = ctx.getClusterConfHash();
        this.mPathConfHash = ctx.getPathConfHash();
        this.mUriValidationEnabled = ctx.getUriValidationEnabled();
    }

    protected ClientContext(Subject subject, AlluxioConfiguration alluxioConf) {
        Objects.requireNonNull(subject, "subject is null");
        this.mClusterConf = Objects.requireNonNull(alluxioConf, "alluxioConf is null");
        this.mClusterConfHash = alluxioConf.hash();
        this.mUserState = UserState.Factory.create(this.mClusterConf, subject);
    }

    public synchronized void loadConf(InetSocketAddress address, boolean loadClusterConf, boolean loadPathConf) throws AlluxioStatusException {
        AlluxioConfiguration conf = this.mClusterConf;
        if (!loadClusterConf && !loadPathConf) {
            return;
        }
        GetConfigurationPResponse response = Configuration.loadConfiguration(address, conf, !loadClusterConf, !loadPathConf);
        if (loadClusterConf) {
            this.mClusterConf = Configuration.getClusterConf(response, conf, Scope.CLIENT);
            this.mClusterConfHash = response.getClusterConfigHash();
        }
        if (loadPathConf) {
            this.mPathConf = Configuration.getPathConf(response, conf);
            this.mPathConfHash = response.getPathConfigHash();
            this.mIsPathConfLoaded = true;
        }
    }

    public synchronized void loadConfIfNotLoaded(InetSocketAddress address) throws AlluxioStatusException {
        if (!this.mClusterConf.getBoolean(PropertyKey.USER_CONF_CLUSTER_DEFAULT_ENABLED)) {
            return;
        }
        this.loadConf(address, !this.mClusterConf.clusterDefaultsLoaded(), !this.mIsPathConfLoaded);
        this.mUserState = UserState.Factory.create(this.mClusterConf, this.mUserState.getSubject());
    }

    public ClientContext setUriValidationEnabled(boolean uriValidationEnabled) {
        this.mUriValidationEnabled = uriValidationEnabled;
        return this;
    }

    public boolean getUriValidationEnabled() {
        return this.mUriValidationEnabled;
    }

    public AlluxioConfiguration getClusterConf() {
        return this.mClusterConf;
    }

    protected void setClusterConf(AlluxioConfiguration alluxioConfiguration) {
        this.mClusterConf = alluxioConfiguration;
    }

    protected void setClusterConfHash(String clusterConfHash) {
        this.mClusterConfHash = clusterConfHash;
    }

    public PathConfiguration getPathConf() {
        return this.mPathConf;
    }

    protected void setPathConf(PathConfiguration pathConfiguration) {
        this.mPathConf = pathConfiguration;
    }

    protected void setPathConfHash(String pathConfHash) {
        this.mPathConfHash = pathConfHash;
    }

    protected void setIsPathConfLoaded(boolean isPathConfLoaded) {
        this.mIsPathConfLoaded = isPathConfLoaded;
    }

    protected boolean getIsPathConfLoaded() {
        return this.mIsPathConfLoaded;
    }

    public String getClusterConfHash() {
        return this.mClusterConfHash;
    }

    public String getPathConfHash() {
        return this.mPathConfHash;
    }

    public Subject getSubject() {
        return this.mUserState.getSubject();
    }

    public UserState getUserState() {
        return this.mUserState;
    }
}

