/*
 * Decompiled with CFR 0.152.
 */
package alluxio.conf;

import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.shaded.client.org.apache.commons.codec.binary.Hex;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Stream;

@ThreadSafe
public final class Hash {
    private final MessageDigest mMD5;
    private final Supplier<Stream<byte[]>> mProperties;
    private final AtomicBoolean mShouldUpdate;
    private volatile String mVersion;
    private volatile long mLastUpdateTime;

    public Hash(Supplier<Stream<byte[]>> properties) {
        try {
            this.mMD5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        this.mProperties = properties;
        this.mShouldUpdate = new AtomicBoolean(true);
    }

    public void markOutdated() {
        this.mShouldUpdate.set(true);
    }

    private String compute() {
        this.mMD5.reset();
        this.mProperties.get().forEach(property -> this.mMD5.update((byte[])property));
        return Hex.encodeHexString(this.mMD5.digest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get() {
        if (this.mShouldUpdate.get()) {
            Hash hash = this;
            synchronized (hash) {
                if (this.mShouldUpdate.get()) {
                    this.mVersion = this.compute();
                    this.mLastUpdateTime = System.currentTimeMillis();
                    this.mShouldUpdate.set(false);
                }
            }
        }
        return this.mVersion;
    }

    public synchronized long getLastUpdateTime() {
        return this.mLastUpdateTime;
    }
}

