/*
 * Decompiled with CFR 0.152.
 */
package alluxio.hadoop;

import alluxio.AlluxioURI;
import alluxio.client.file.CacheContext;
import alluxio.client.file.FileInStream;
import alluxio.client.file.URIStatus;
import alluxio.client.file.cache.CacheManager;
import alluxio.client.file.cache.LocalCacheFileInStream;
import alluxio.client.file.cache.filter.CacheFilter;
import alluxio.conf.AlluxioConfiguration;
import alluxio.exception.AlluxioException;
import alluxio.hadoop.AlluxioHdfsInputStream;
import alluxio.hadoop.HadoopFileOpener;
import alluxio.hadoop.HadoopUtils;
import alluxio.hadoop.HdfsFileInputStream;
import alluxio.metrics.MetricsConfig;
import alluxio.metrics.MetricsSystem;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.common.hash.Hashing;
import alluxio.wire.FileInfo;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalCacheFileSystem
extends FileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(LocalCacheFileSystem.class);
    private final FileSystem mExternalFileSystem;
    private final HadoopFileOpener mHadoopFileOpener;
    private final LocalCacheFileInStream.FileInStreamOpener mAlluxioFileOpener;
    private CacheManager mCacheManager;
    private CacheFilter mCacheFilter;
    private Configuration mHadoopConf;
    private AlluxioConfiguration mAlluxioConf;

    public LocalCacheFileSystem(FileSystem fileSystem) {
        this(fileSystem, uriStatus -> fileSystem.open(new Path(uriStatus.getPath())));
    }

    public LocalCacheFileSystem(FileSystem fileSystem, HadoopFileOpener fileOpener) {
        this.mExternalFileSystem = Preconditions.checkNotNull(fileSystem, "filesystem");
        this.mHadoopFileOpener = Preconditions.checkNotNull(fileOpener, "fileOpener");
        this.mAlluxioFileOpener = status -> new AlluxioHdfsInputStream(this.mHadoopFileOpener.open(status));
    }

    public synchronized void initialize(URI uri, Configuration conf) throws IOException {
        super.initialize(uri, conf);
        this.mHadoopConf = conf;
        this.setConf(conf);
        this.mAlluxioConf = HadoopUtils.toAlluxioConf(this.mHadoopConf);
        Properties metricsProperties = new Properties();
        for (Map.Entry entry : conf) {
            metricsProperties.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        MetricsSystem.startSinksFromConfig(new MetricsConfig(metricsProperties));
        this.mCacheManager = CacheManager.Factory.get(this.mAlluxioConf);
        this.mCacheFilter = CacheFilter.create(this.mAlluxioConf);
        LocalCacheFileInStream.registerMetrics();
    }

    public void close() throws IOException {
        super.close();
    }

    public String getScheme() {
        return this.mExternalFileSystem.getScheme();
    }

    public FSDataInputStream open(Path path, int bufferSize) throws IOException {
        if (this.mCacheManager == null) {
            return this.mExternalFileSystem.open(path, bufferSize);
        }
        FileStatus externalFileStatus = this.mExternalFileSystem.getFileStatus(path);
        FileInfo info = new FileInfo().setLength(externalFileStatus.getLen()).setPath(externalFileStatus.getPath().toString()).setFolder(externalFileStatus.isDirectory()).setBlockSizeBytes(externalFileStatus.getBlockSize()).setLastModificationTimeMs(externalFileStatus.getModificationTime()).setLastAccessTimeMs(externalFileStatus.getAccessTime()).setOwner(externalFileStatus.getOwner()).setGroup(externalFileStatus.getGroup());
        CacheContext context = CacheContext.defaults().setCacheIdentifier(Hashing.md5().hashString(externalFileStatus.getPath().toString(), StandardCharsets.UTF_8).toString());
        URIStatus status = new URIStatus(info, context);
        return this.open(status, bufferSize);
    }

    public FSDataInputStream open(URIStatus status, int bufferSize) throws IOException {
        return this.open(status, bufferSize, false);
    }

    public FSDataInputStream open(URIStatus status, int bufferSize, boolean enforceOpen) throws IOException {
        Optional<FileInStream> externalFileInStream;
        if (this.mCacheManager == null || !this.mCacheFilter.needsCache(status)) {
            return this.mExternalFileSystem.open(HadoopUtils.toPath(new AlluxioURI(status.getPath())), bufferSize);
        }
        if (enforceOpen) {
            try {
                externalFileInStream = Optional.of(this.mAlluxioFileOpener.open(status));
            }
            catch (AlluxioException e) {
                throw new IOException(e);
            }
        } else {
            externalFileInStream = Optional.empty();
        }
        return new FSDataInputStream((InputStream)new HdfsFileInputStream(new LocalCacheFileInStream(status, this.mAlluxioFileOpener, this.mCacheManager, this.mAlluxioConf, externalFileInStream), this.statistics));
    }

    public URI getUri() {
        return this.mExternalFileSystem.getUri();
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.mExternalFileSystem.create(f, permission, overwrite, bufferSize, replication, blockSize, progress);
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        return this.mExternalFileSystem.append(f, bufferSize, progress);
    }

    public boolean rename(Path src, Path dst) throws IOException {
        return this.mExternalFileSystem.rename(src, dst);
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        return this.mExternalFileSystem.delete(f, recursive);
    }

    public FileStatus[] listStatus(Path f) throws FileNotFoundException, IOException {
        return this.mExternalFileSystem.listStatus(f);
    }

    public void setWorkingDirectory(Path new_dir) {
        this.mExternalFileSystem.setWorkingDirectory(new_dir);
    }

    public Path getWorkingDirectory() {
        return this.mExternalFileSystem.getWorkingDirectory();
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        return this.mExternalFileSystem.mkdirs(f, permission);
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        return this.mExternalFileSystem.getFileStatus(f);
    }
}

