/*
 * Decompiled with CFR 0.152.
 */
package alluxio.heartbeat;

import alluxio.heartbeat.SleepIntervalSupplier;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.org.apache.logging.log4j.core.util.CronExpression;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Objects;

public class CronExpressionIntervalSupplier
implements SleepIntervalSupplier {
    private final long mInterval;
    private final CronExpression mCron;

    public CronExpressionIntervalSupplier(CronExpression cronExpression, long fixedInterval) {
        Preconditions.checkNotNull(cronExpression, "CronExpression is null");
        this.mInterval = fixedInterval;
        this.mCron = cronExpression;
    }

    @Override
    public long getNextInterval(long previousTickedMs, long nowTimeStampMillis) {
        Date now;
        long nextInterval = 0L;
        long executionTimeMs = nowTimeStampMillis - previousTickedMs;
        if (executionTimeMs < this.mInterval) {
            nextInterval = this.mInterval - executionTimeMs;
        }
        if (this.mCron.isSatisfiedBy(now = Date.from(Instant.ofEpochMilli(nowTimeStampMillis + nextInterval)))) {
            return nextInterval;
        }
        return nextInterval + Duration.between(now.toInstant(), this.mCron.getNextValidTimeAfter(now).toInstant()).toMillis();
    }

    @Override
    public long getRunLimit(long previousTickedMs) {
        Date now = Date.from(Instant.ofEpochMilli(previousTickedMs));
        return Duration.between(now.toInstant(), this.mCron.getNextInvalidTimeAfter(now).toInstant()).toMillis();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CronExpressionIntervalSupplier that = (CronExpressionIntervalSupplier)o;
        return this.mInterval == that.mInterval && Objects.equals(this.mCron.getCronExpression(), that.mCron.getCronExpression());
    }

    public int hashCode() {
        return Objects.hash(this.mInterval, this.mCron.getCronExpression());
    }
}

