/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.com.google.inject.internal;

import alluxio.shaded.client.com.google.common.collect.Lists;
import alluxio.shaded.client.com.google.inject.Key;
import alluxio.shaded.client.com.google.inject.MembersInjector;
import alluxio.shaded.client.com.google.inject.Provider;
import alluxio.shaded.client.com.google.inject.TypeLiteral;
import alluxio.shaded.client.com.google.inject.internal.Errors;
import alluxio.shaded.client.com.google.inject.internal.InjectorImpl;
import alluxio.shaded.client.com.google.inject.internal.LookupProcessor;
import alluxio.shaded.client.com.google.inject.internal.Lookups;
import alluxio.shaded.client.com.google.inject.spi.Element;
import alluxio.shaded.client.com.google.inject.spi.MembersInjectorLookup;
import alluxio.shaded.client.com.google.inject.spi.ProviderLookup;
import java.util.List;

final class DeferredLookups
implements Lookups {
    private final InjectorImpl injector;
    private final List<Element> lookups = Lists.newArrayList();

    DeferredLookups(InjectorImpl injector) {
        this.injector = injector;
    }

    void initialize(Errors errors) {
        this.injector.lookups = this.injector;
        new LookupProcessor(errors).process(this.injector, this.lookups);
    }

    @Override
    public <T> Provider<T> getProvider(Key<T> key) {
        ProviderLookup<T> lookup = new ProviderLookup<T>(key, key);
        this.lookups.add(lookup);
        return lookup.getProvider();
    }

    @Override
    public <T> MembersInjector<T> getMembersInjector(TypeLiteral<T> type) {
        MembersInjectorLookup<T> lookup = new MembersInjectorLookup<T>(type, type);
        this.lookups.add(lookup);
        return lookup.getMembersInjector();
    }
}

