/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.software.amazon.ionimpl.lite;

import alluxio.shaded.client.software.amazon.ionDecimal;
import alluxio.shaded.client.software.amazon.ionIonDecimal;
import alluxio.shaded.client.software.amazon.ionIonType;
import alluxio.shaded.client.software.amazon.ionIonWriter;
import alluxio.shaded.client.software.amazon.ionNullValueException;
import alluxio.shaded.client.software.amazon.ionValueVisitor;
import alluxio.shaded.client.software.amazon.ionimpl.PrivateIonValue;
import alluxio.shaded.client.software.amazon.ionimpl.lite.ContainerlessContext;
import alluxio.shaded.client.software.amazon.ionimpl.lite.IonContext;
import alluxio.shaded.client.software.amazon.ionimpl.lite.IonValueLite;
import java.io.IOException;
import java.math.BigDecimal;

final class IonDecimalLite
extends IonValueLite
implements ionIonDecimal {
    private static final int HASH_SIGNATURE = ionIonType.DECIMAL.toString().hashCode();
    private static final int NEGATIVE_ZERO_HASH_SIGNATURE = "NEGATIVE ZERO".hashCode();
    private BigDecimal _decimal_value;

    public static boolean isNegativeZero(float value) {
        if (value != 0.0f) {
            return false;
        }
        return (Float.floatToRawIntBits(value) & Integer.MIN_VALUE) != 0;
    }

    public static boolean isNegativeZero(double value) {
        if (value != 0.0) {
            return false;
        }
        return (Double.doubleToLongBits(value) & Long.MIN_VALUE) != 0L;
    }

    IonDecimalLite(ContainerlessContext context, boolean isNull) {
        super(context, isNull);
    }

    IonDecimalLite(IonDecimalLite existing, IonContext context) {
        super(existing, context);
        this._decimal_value = existing._decimal_value;
    }

    IonDecimalLite clone(IonContext parentContext) {
        return new IonDecimalLite(this, parentContext);
    }

    public IonDecimalLite clone() {
        return this.clone(ContainerlessContext.wrap(this.getSystem()));
    }

    int hashCode(PrivateIonValue.SymbolTableProvider symbolTableProvider) {
        int result = HASH_SIGNATURE;
        if (!this.isNullValue()) {
            ionDecimal dec = this.decimalValue();
            result ^= dec.hashCode();
            if (dec.isNegativeZero()) {
                result ^= NEGATIVE_ZERO_HASH_SIGNATURE;
            }
        }
        return this.hashTypeAnnotations(result, symbolTableProvider);
    }

    public ionIonType getType() {
        return ionIonType.DECIMAL;
    }

    public float floatValue() throws ionNullValueException {
        if (this._isNullValue()) {
            throw new ionNullValueException();
        }
        float f = this._decimal_value.floatValue();
        return f;
    }

    public double doubleValue() throws ionNullValueException {
        if (this._isNullValue()) {
            throw new ionNullValueException();
        }
        double d = this._decimal_value.doubleValue();
        return d;
    }

    public BigDecimal bigDecimalValue() throws ionNullValueException {
        return ionDecimal.bigDecimalValue(this._decimal_value);
    }

    public ionDecimal decimalValue() throws ionNullValueException {
        return ionDecimal.valueOf(this._decimal_value);
    }

    public void setValue(long value) {
        this.setValue(ionDecimal.valueOf(value));
    }

    public void setValue(float value) {
        this.setValue(ionDecimal.valueOf(value));
    }

    public void setValue(double value) {
        this.setValue(ionDecimal.valueOf(value));
    }

    public void setValue(BigDecimal value) {
        this.checkForLock();
        this._decimal_value = value;
        this._isNullValue(value == null);
    }

    final void writeBodyTo(ionIonWriter writer, PrivateIonValue.SymbolTableProvider symbolTableProvider) throws IOException {
        writer.writeDecimal(this._decimal_value);
    }

    public void accept(ionValueVisitor visitor) throws Exception {
        visitor.visit(this);
    }
}

