/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util.compression;

import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.util.compression.GzipMarshaller;
import alluxio.util.compression.NoCompressionMarshaller;
import alluxio.util.compression.TarGzMarshaller;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;

public interface DirectoryMarshaller {
    public long write(Path var1, OutputStream var2) throws IOException, InterruptedException;

    public long read(Path var1, InputStream var2) throws IOException;

    public static class Factory {
        public static DirectoryMarshaller create() {
            Type compressionType = Configuration.getEnum(PropertyKey.MASTER_EMBEDDED_JOURNAL_SNAPSHOT_REPLICATION_COMPRESSION_TYPE, Type.class);
            switch (compressionType) {
                case GZIP: {
                    return new GzipMarshaller();
                }
                case TAR_GZIP: {
                    return new TarGzMarshaller();
                }
            }
            return new NoCompressionMarshaller();
        }
    }

    public static enum Type {
        NO_COMPRESSION,
        GZIP,
        TAR_GZIP;

    }
}

