/*
 * Copyright 2014-2020 Amazon.alluxio.shaded.client.com. Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in alluxio.shaded.client.com.liance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.alluxio.shaded.client.com.apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package alluxio.shaded.client.com.amazonaws.auth.profile.internal;

import alluxio.shaded.client.com.amazonaws.auth.AWSCredentials;
import alluxio.shaded.client.com.amazonaws.auth.AWSCredentialsProvider;
import alluxio.shaded.client.com.amazonaws.auth.ProcessCredentialsProvider;

/**
 * A profile-based wrapper around {@link ProcessCredentialsProvider}, implementing the credential_process profile setting.
 */
public class ProfileProcessCredentialsProvider implements AWSCredentialsProvider {
    private final ProcessCredentialsProvider delegate;

    public ProfileProcessCredentialsProvider(BasicProfile profile) {
        this.delegate = ProcessCredentialsProvider.builder()
                                                  .withCommand(profile.getCredentialProcess())
                                                  .build();
    }

    @Override
    public AWSCredentials getCredentials() {
        return delegate.getCredentials();
    }

    @Override
    public void refresh() {
        delegate.refresh();
    }
}
