/*
 * Copyright 2011-2020 Amazon.alluxio.shaded.client.com. Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in alluxio.shaded.client.com.liance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.alluxio.shaded.client.com.apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package alluxio.shaded.client.com.amazonaws.internal;

import alluxio.shaded.client.com.amazonaws.AmazonWebServiceRequest;
import alluxio.shaded.client.com.amazonaws.RequestClientOptions;
import alluxio.shaded.client.com.amazonaws.RequestConfig;
import alluxio.shaded.client.com.amazonaws.annotation.SdkInternalApi;
import alluxio.shaded.client.com.amazonaws.auth.AWSCredentialsProvider;
import alluxio.shaded.client.com.amazonaws.event.ProgressListener;
import alluxio.shaded.client.com.amazonaws.metrics.RequestMetricCollector;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * Adapts the configuration present in {@link AmazonWebServiceRequest} to {@link RequestConfig}.
 */
@SdkInternalApi
public final class AmazonWebServiceRequestAdapter extends RequestConfig {

    private final AmazonWebServiceRequest request;

    public AmazonWebServiceRequestAdapter(AmazonWebServiceRequest request) {
        this.request = request;
    }

    @Override
    public ProgressListener getProgressListener() {
        return request.getGeneralProgressListener();
    }

    @Override
    public RequestMetricCollector getRequestMetricsCollector() {
        return request.getRequestMetricCollector();
    }

    @Override
    public AWSCredentialsProvider getCredentialsProvider() {
        return request.getRequestCredentialsProvider();
    }

    @Override
    public Map<String, String> getCustomRequestHeaders() {
        return (request.getCustomRequestHeaders() == null) ? Collections.<String, String>emptyMap() :
                request.getCustomRequestHeaders();
    }

    @Override
    public Map<String, List<String>> getCustomQueryParameters() {
        return (request.getCustomQueryParameters() == null) ? Collections.<String, List<String>>emptyMap() :
                request.getCustomQueryParameters();
    }

    @Override
    public Integer getRequestTimeout() {
        return request.getSdkRequestTimeout();
    }

    @Override
    public Integer getClientExecutionTimeout() {
        return request.getSdkClientExecutionTimeout();
    }

    @Override
    public RequestClientOptions getRequestClientOptions() {
        return request.getRequestClientOptions();
    }

    @Override
    public String getRequestType() {
        return request.getClass().getSimpleName();
    }

    @Override
    public Object getOriginalRequest() {
        return request;
    }
}
