package alluxio.shaded.client.io.etcd.jetcd.api;

import static alluxio.shaded.client.io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 * The election service exposes client-side election facilities as a gRPC interface.
 * </pre>
 */
@alluxio.shaded.client.javax.annotation.Generated(
    value = "by gRPC proto alluxio.shaded.client.com.iler (version 1.51.0)",
    alluxio.shaded.client.com.ents = "Source: election.proto")
@alluxio.shaded.client.io.grpc.stub.annotations.GrpcGenerated
public final class ElectionGrpc {

  private ElectionGrpc() {}

  public static final String SERVICE_NAME = "v3electionpb.Election";

  // Static method descriptors that strictly reflect the proto.
  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.shaded.client.io.etcd.jetcd.api.CampaignRequest,
      alluxio.shaded.client.io.etcd.jetcd.api.CampaignResponse> getCampaignMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Campaign",
      requestType = alluxio.shaded.client.io.etcd.jetcd.api.CampaignRequest.class,
      responseType = alluxio.shaded.client.io.etcd.jetcd.api.CampaignResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.shaded.client.io.etcd.jetcd.api.CampaignRequest,
      alluxio.shaded.client.io.etcd.jetcd.api.CampaignResponse> getCampaignMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.shaded.client.io.etcd.jetcd.api.CampaignRequest, alluxio.shaded.client.io.etcd.jetcd.api.CampaignResponse> getCampaignMethod;
    if ((getCampaignMethod = ElectionGrpc.getCampaignMethod) == null) {
      synchronized (ElectionGrpc.class) {
        if ((getCampaignMethod = ElectionGrpc.getCampaignMethod) == null) {
          ElectionGrpc.getCampaignMethod = getCampaignMethod =
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.shaded.client.io.etcd.jetcd.api.CampaignRequest, alluxio.shaded.client.io.etcd.jetcd.api.CampaignResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Campaign"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.shaded.client.io.etcd.jetcd.api.CampaignRequest.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.shaded.client.io.etcd.jetcd.api.CampaignResponse.getDefaultInstance()))
              .setSchemaDescriptor(new ElectionMethodDescriptorSupplier("Campaign"))
              .build();
        }
      }
    }
    return getCampaignMethod;
  }

  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.shaded.client.io.etcd.jetcd.api.ProclaimRequest,
      alluxio.shaded.client.io.etcd.jetcd.api.ProclaimResponse> getProclaimMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Proclaim",
      requestType = alluxio.shaded.client.io.etcd.jetcd.api.ProclaimRequest.class,
      responseType = alluxio.shaded.client.io.etcd.jetcd.api.ProclaimResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.shaded.client.io.etcd.jetcd.api.ProclaimRequest,
      alluxio.shaded.client.io.etcd.jetcd.api.ProclaimResponse> getProclaimMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.shaded.client.io.etcd.jetcd.api.ProclaimRequest, alluxio.shaded.client.io.etcd.jetcd.api.ProclaimResponse> getProclaimMethod;
    if ((getProclaimMethod = ElectionGrpc.getProclaimMethod) == null) {
      synchronized (ElectionGrpc.class) {
        if ((getProclaimMethod = ElectionGrpc.getProclaimMethod) == null) {
          ElectionGrpc.getProclaimMethod = getProclaimMethod =
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.shaded.client.io.etcd.jetcd.api.ProclaimRequest, alluxio.shaded.client.io.etcd.jetcd.api.ProclaimResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Proclaim"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.shaded.client.io.etcd.jetcd.api.ProclaimRequest.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.shaded.client.io.etcd.jetcd.api.ProclaimResponse.getDefaultInstance()))
              .setSchemaDescriptor(new ElectionMethodDescriptorSupplier("Proclaim"))
              .build();
        }
      }
    }
    return getProclaimMethod;
  }

  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.shaded.client.io.etcd.jetcd.api.LeaderRequest,
      alluxio.shaded.client.io.etcd.jetcd.api.LeaderResponse> getLeaderMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Leader",
      requestType = alluxio.shaded.client.io.etcd.jetcd.api.LeaderRequest.class,
      responseType = alluxio.shaded.client.io.etcd.jetcd.api.LeaderResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.shaded.client.io.etcd.jetcd.api.LeaderRequest,
      alluxio.shaded.client.io.etcd.jetcd.api.LeaderResponse> getLeaderMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.shaded.client.io.etcd.jetcd.api.LeaderRequest, alluxio.shaded.client.io.etcd.jetcd.api.LeaderResponse> getLeaderMethod;
    if ((getLeaderMethod = ElectionGrpc.getLeaderMethod) == null) {
      synchronized (ElectionGrpc.class) {
        if ((getLeaderMethod = ElectionGrpc.getLeaderMethod) == null) {
          ElectionGrpc.getLeaderMethod = getLeaderMethod =
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.shaded.client.io.etcd.jetcd.api.LeaderRequest, alluxio.shaded.client.io.etcd.jetcd.api.LeaderResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Leader"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.shaded.client.io.etcd.jetcd.api.LeaderRequest.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.shaded.client.io.etcd.jetcd.api.LeaderResponse.getDefaultInstance()))
              .setSchemaDescriptor(new ElectionMethodDescriptorSupplier("Leader"))
              .build();
        }
      }
    }
    return getLeaderMethod;
  }

  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.shaded.client.io.etcd.jetcd.api.LeaderRequest,
      alluxio.shaded.client.io.etcd.jetcd.api.LeaderResponse> getObserveMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Observe",
      requestType = alluxio.shaded.client.io.etcd.jetcd.api.LeaderRequest.class,
      responseType = alluxio.shaded.client.io.etcd.jetcd.api.LeaderResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.shaded.client.io.etcd.jetcd.api.LeaderRequest,
      alluxio.shaded.client.io.etcd.jetcd.api.LeaderResponse> getObserveMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.shaded.client.io.etcd.jetcd.api.LeaderRequest, alluxio.shaded.client.io.etcd.jetcd.api.LeaderResponse> getObserveMethod;
    if ((getObserveMethod = ElectionGrpc.getObserveMethod) == null) {
      synchronized (ElectionGrpc.class) {
        if ((getObserveMethod = ElectionGrpc.getObserveMethod) == null) {
          ElectionGrpc.getObserveMethod = getObserveMethod =
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.shaded.client.io.etcd.jetcd.api.LeaderRequest, alluxio.shaded.client.io.etcd.jetcd.api.LeaderResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Observe"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.shaded.client.io.etcd.jetcd.api.LeaderRequest.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.shaded.client.io.etcd.jetcd.api.LeaderResponse.getDefaultInstance()))
              .setSchemaDescriptor(new ElectionMethodDescriptorSupplier("Observe"))
              .build();
        }
      }
    }
    return getObserveMethod;
  }

  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.shaded.client.io.etcd.jetcd.api.ResignRequest,
      alluxio.shaded.client.io.etcd.jetcd.api.ResignResponse> getResignMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Resign",
      requestType = alluxio.shaded.client.io.etcd.jetcd.api.ResignRequest.class,
      responseType = alluxio.shaded.client.io.etcd.jetcd.api.ResignResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.shaded.client.io.etcd.jetcd.api.ResignRequest,
      alluxio.shaded.client.io.etcd.jetcd.api.ResignResponse> getResignMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.shaded.client.io.etcd.jetcd.api.ResignRequest, alluxio.shaded.client.io.etcd.jetcd.api.ResignResponse> getResignMethod;
    if ((getResignMethod = ElectionGrpc.getResignMethod) == null) {
      synchronized (ElectionGrpc.class) {
        if ((getResignMethod = ElectionGrpc.getResignMethod) == null) {
          ElectionGrpc.getResignMethod = getResignMethod =
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.shaded.client.io.etcd.jetcd.api.ResignRequest, alluxio.shaded.client.io.etcd.jetcd.api.ResignResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Resign"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.shaded.client.io.etcd.jetcd.api.ResignRequest.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.shaded.client.io.etcd.jetcd.api.ResignResponse.getDefaultInstance()))
              .setSchemaDescriptor(new ElectionMethodDescriptorSupplier("Resign"))
              .build();
        }
      }
    }
    return getResignMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static ElectionStub newStub(alluxio.shaded.client.io.grpc.Channel channel) {
    alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<ElectionStub> factory =
      new alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<ElectionStub>() {
        @java.lang.Override
        public ElectionStub newStub(alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
          return new ElectionStub(channel, callOptions);
        }
      };
    return ElectionStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static ElectionBlockingStub newBlockingStub(
      alluxio.shaded.client.io.grpc.Channel channel) {
    alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<ElectionBlockingStub> factory =
      new alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<ElectionBlockingStub>() {
        @java.lang.Override
        public ElectionBlockingStub newStub(alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
          return new ElectionBlockingStub(channel, callOptions);
        }
      };
    return ElectionBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static ElectionFutureStub newFutureStub(
      alluxio.shaded.client.io.grpc.Channel channel) {
    alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<ElectionFutureStub> factory =
      new alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<ElectionFutureStub>() {
        @java.lang.Override
        public ElectionFutureStub newStub(alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
          return new ElectionFutureStub(channel, callOptions);
        }
      };
    return ElectionFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   * The election service exposes client-side election facilities as a gRPC interface.
   * </pre>
   */
  public static abstract class ElectionImplBase implements alluxio.shaded.client.io.grpc.BindableService {

    /**
     * <pre>
     * Campaign waits to acquire leadership in an election, returning a LeaderKey
     * representing the leadership if successful. The LeaderKey can then be used
     * to issue new values on the election, transactionally guard API requests on
     * leadership still being held, and resign from the election.
     * </pre>
     */
    public void campaign(alluxio.shaded.client.io.etcd.jetcd.api.CampaignRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.CampaignResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getCampaignMethod(), responseObserver);
    }

    /**
     * <pre>
     * Proclaim updates the leader's posted value with a new value.
     * </pre>
     */
    public void proclaim(alluxio.shaded.client.io.etcd.jetcd.api.ProclaimRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.ProclaimResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getProclaimMethod(), responseObserver);
    }

    /**
     * <pre>
     * Leader returns the current election proclamation, if any.
     * </pre>
     */
    public void leader(alluxio.shaded.client.io.etcd.jetcd.api.LeaderRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.LeaderResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getLeaderMethod(), responseObserver);
    }

    /**
     * <pre>
     * Observe streams election proclamations in-order as made by the election's
     * elected leaders.
     * </pre>
     */
    public void observe(alluxio.shaded.client.io.etcd.jetcd.api.LeaderRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.LeaderResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getObserveMethod(), responseObserver);
    }

    /**
     * <pre>
     * Resign releases election leadership so other campaigners may acquire
     * leadership on the election.
     * </pre>
     */
    public void resign(alluxio.shaded.client.io.etcd.jetcd.api.ResignRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.ResignResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getResignMethod(), responseObserver);
    }

    @java.lang.Override public final alluxio.shaded.client.io.grpc.ServerServiceDefinition bindService() {
      return alluxio.shaded.client.io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getCampaignMethod(),
            alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                alluxio.shaded.client.io.etcd.jetcd.api.CampaignRequest,
                alluxio.shaded.client.io.etcd.jetcd.api.CampaignResponse>(
                  this, METHODID_CAMPAIGN)))
          .addMethod(
            getProclaimMethod(),
            alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                alluxio.shaded.client.io.etcd.jetcd.api.ProclaimRequest,
                alluxio.shaded.client.io.etcd.jetcd.api.ProclaimResponse>(
                  this, METHODID_PROCLAIM)))
          .addMethod(
            getLeaderMethod(),
            alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                alluxio.shaded.client.io.etcd.jetcd.api.LeaderRequest,
                alluxio.shaded.client.io.etcd.jetcd.api.LeaderResponse>(
                  this, METHODID_LEADER)))
          .addMethod(
            getObserveMethod(),
            alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncServerStreamingCall(
              new MethodHandlers<
                alluxio.shaded.client.io.etcd.jetcd.api.LeaderRequest,
                alluxio.shaded.client.io.etcd.jetcd.api.LeaderResponse>(
                  this, METHODID_OBSERVE)))
          .addMethod(
            getResignMethod(),
            alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                alluxio.shaded.client.io.etcd.jetcd.api.ResignRequest,
                alluxio.shaded.client.io.etcd.jetcd.api.ResignResponse>(
                  this, METHODID_RESIGN)))
          .build();
    }
  }

  /**
   * <pre>
   * The election service exposes client-side election facilities as a gRPC interface.
   * </pre>
   */
  public static final class ElectionStub extends alluxio.shaded.client.io.grpc.stub.AbstractAsyncStub<ElectionStub> {
    private ElectionStub(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected ElectionStub build(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      return new ElectionStub(channel, callOptions);
    }

    /**
     * <pre>
     * Campaign waits to acquire leadership in an election, returning a LeaderKey
     * representing the leadership if successful. The LeaderKey can then be used
     * to issue new values on the election, transactionally guard API requests on
     * leadership still being held, and resign from the election.
     * </pre>
     */
    public void campaign(alluxio.shaded.client.io.etcd.jetcd.api.CampaignRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.CampaignResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getCampaignMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Proclaim updates the leader's posted value with a new value.
     * </pre>
     */
    public void proclaim(alluxio.shaded.client.io.etcd.jetcd.api.ProclaimRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.ProclaimResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getProclaimMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Leader returns the current election proclamation, if any.
     * </pre>
     */
    public void leader(alluxio.shaded.client.io.etcd.jetcd.api.LeaderRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.LeaderResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getLeaderMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Observe streams election proclamations in-order as made by the election's
     * elected leaders.
     * </pre>
     */
    public void observe(alluxio.shaded.client.io.etcd.jetcd.api.LeaderRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.LeaderResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncServerStreamingCall(
          getChannel().newCall(getObserveMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Resign releases election leadership so other campaigners may acquire
     * leadership on the election.
     * </pre>
     */
    public void resign(alluxio.shaded.client.io.etcd.jetcd.api.ResignRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.ResignResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getResignMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * The election service exposes client-side election facilities as a gRPC interface.
   * </pre>
   */
  public static final class ElectionBlockingStub extends alluxio.shaded.client.io.grpc.stub.AbstractBlockingStub<ElectionBlockingStub> {
    private ElectionBlockingStub(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected ElectionBlockingStub build(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      return new ElectionBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Campaign waits to acquire leadership in an election, returning a LeaderKey
     * representing the leadership if successful. The LeaderKey can then be used
     * to issue new values on the election, transactionally guard API requests on
     * leadership still being held, and resign from the election.
     * </pre>
     */
    public alluxio.shaded.client.io.etcd.jetcd.api.CampaignResponse campaign(alluxio.shaded.client.io.etcd.jetcd.api.CampaignRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getCampaignMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Proclaim updates the leader's posted value with a new value.
     * </pre>
     */
    public alluxio.shaded.client.io.etcd.jetcd.api.ProclaimResponse proclaim(alluxio.shaded.client.io.etcd.jetcd.api.ProclaimRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getProclaimMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Leader returns the current election proclamation, if any.
     * </pre>
     */
    public alluxio.shaded.client.io.etcd.jetcd.api.LeaderResponse leader(alluxio.shaded.client.io.etcd.jetcd.api.LeaderRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getLeaderMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Observe streams election proclamations in-order as made by the election's
     * elected leaders.
     * </pre>
     */
    public java.util.Iterator<alluxio.shaded.client.io.etcd.jetcd.api.LeaderResponse> observe(
        alluxio.shaded.client.io.etcd.jetcd.api.LeaderRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.blockingServerStreamingCall(
          getChannel(), getObserveMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Resign releases election leadership so other campaigners may acquire
     * leadership on the election.
     * </pre>
     */
    public alluxio.shaded.client.io.etcd.jetcd.api.ResignResponse resign(alluxio.shaded.client.io.etcd.jetcd.api.ResignRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getResignMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * The election service exposes client-side election facilities as a gRPC interface.
   * </pre>
   */
  public static final class ElectionFutureStub extends alluxio.shaded.client.io.grpc.stub.AbstractFutureStub<ElectionFutureStub> {
    private ElectionFutureStub(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected ElectionFutureStub build(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      return new ElectionFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Campaign waits to acquire leadership in an election, returning a LeaderKey
     * representing the leadership if successful. The LeaderKey can then be used
     * to issue new values on the election, transactionally guard API requests on
     * leadership still being held, and resign from the election.
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.shaded.client.io.etcd.jetcd.api.CampaignResponse> campaign(
        alluxio.shaded.client.io.etcd.jetcd.api.CampaignRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getCampaignMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Proclaim updates the leader's posted value with a new value.
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.shaded.client.io.etcd.jetcd.api.ProclaimResponse> proclaim(
        alluxio.shaded.client.io.etcd.jetcd.api.ProclaimRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getProclaimMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Leader returns the current election proclamation, if any.
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.shaded.client.io.etcd.jetcd.api.LeaderResponse> leader(
        alluxio.shaded.client.io.etcd.jetcd.api.LeaderRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getLeaderMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Resign releases election leadership so other campaigners may acquire
     * leadership on the election.
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.shaded.client.io.etcd.jetcd.api.ResignResponse> resign(
        alluxio.shaded.client.io.etcd.jetcd.api.ResignRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getResignMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_CAMPAIGN = 0;
  private static final int METHODID_PROCLAIM = 1;
  private static final int METHODID_LEADER = 2;
  private static final int METHODID_OBSERVE = 3;
  private static final int METHODID_RESIGN = 4;

  private static final class MethodHandlers<Req, Resp> implements
      alluxio.shaded.client.io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      alluxio.shaded.client.io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      alluxio.shaded.client.io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      alluxio.shaded.client.io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final ElectionImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(ElectionImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, alluxio.shaded.client.io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_CAMPAIGN:
          serviceImpl.campaign((alluxio.shaded.client.io.etcd.jetcd.api.CampaignRequest) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.CampaignResponse>) responseObserver);
          break;
        case METHODID_PROCLAIM:
          serviceImpl.proclaim((alluxio.shaded.client.io.etcd.jetcd.api.ProclaimRequest) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.ProclaimResponse>) responseObserver);
          break;
        case METHODID_LEADER:
          serviceImpl.leader((alluxio.shaded.client.io.etcd.jetcd.api.LeaderRequest) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.LeaderResponse>) responseObserver);
          break;
        case METHODID_OBSERVE:
          serviceImpl.observe((alluxio.shaded.client.io.etcd.jetcd.api.LeaderRequest) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.LeaderResponse>) responseObserver);
          break;
        case METHODID_RESIGN:
          serviceImpl.resign((alluxio.shaded.client.io.etcd.jetcd.api.ResignRequest) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.ResignResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public alluxio.shaded.client.io.grpc.stub.StreamObserver<Req> invoke(
        alluxio.shaded.client.io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class ElectionBaseDescriptorSupplier
      implements alluxio.shaded.client.io.grpc.protobuf.ProtoFileDescriptorSupplier, alluxio.shaded.client.io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    ElectionBaseDescriptorSupplier() {}

    @java.lang.Override
    public alluxio.shaded.client.com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return alluxio.shaded.client.io.etcd.jetcd.api.ElectionOuterClass.getDescriptor();
    }

    @java.lang.Override
    public alluxio.shaded.client.com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("Election");
    }
  }

  private static final class ElectionFileDescriptorSupplier
      extends ElectionBaseDescriptorSupplier {
    ElectionFileDescriptorSupplier() {}
  }

  private static final class ElectionMethodDescriptorSupplier
      extends ElectionBaseDescriptorSupplier
      implements alluxio.shaded.client.io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    ElectionMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public alluxio.shaded.client.com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile alluxio.shaded.client.io.grpc.ServiceDescriptor serviceDescriptor;

  public static alluxio.shaded.client.io.grpc.ServiceDescriptor getServiceDescriptor() {
    alluxio.shaded.client.io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (ElectionGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = alluxio.shaded.client.io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new ElectionFileDescriptorSupplier())
              .addMethod(getCampaignMethod())
              .addMethod(getProclaimMethod())
              .addMethod(getLeaderMethod())
              .addMethod(getObserveMethod())
              .addMethod(getResignMethod())
              .build();
        }
      }
    }
    return result;
  }
}
