/*
 * Copyright (c) 2011-2019 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.alluxio.shaded.client.org.legal/epl-2.0, or the Apache License, Version 2.0
 * which is available at https://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0
 */

package alluxio.shaded.client.io.vertx.core.cli.converters;

/**
 * The converter interface to convert {@code String}s to {@code Object}s.
 *
 * @author Clement Escoffier <clement@apache.alluxio.shaded.client.org.
 */
@FunctionalInterface
public interface Converter<T> {

  T fromString(String s);

}
