/*
 * Decompiled with CFR 0.152.
 */
package alluxio.membership;

import alluxio.annotation.SuppressFBWarnings;
import alluxio.grpc.GrpcUtils;
import alluxio.membership.ServiceEntity;
import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.com.google.common.base.Objects;
import alluxio.util.HashUtils;
import alluxio.wire.WorkerNetAddress;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class WorkerServiceEntity
extends ServiceEntity {
    WorkerNetAddress mAddress;
    State mState = State.JOINED;
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    int mGenerationNum = -1;

    public WorkerServiceEntity() {
    }

    public WorkerServiceEntity(WorkerNetAddress addr) {
        super(HashUtils.hashAsStringMD5(addr.dumpMainInfo()));
        this.mAddress = addr;
        this.mState = State.AUTHORIZED;
    }

    public WorkerNetAddress getWorkerNetAddress() {
        return this.mAddress;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("WorkerId", this.getServiceEntityName()).add("WorkerAddr", this.mAddress.toString()).add("State", this.mState.toString()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkerServiceEntity anotherO = (WorkerServiceEntity)o;
        return this.mAddress.equals(anotherO.mAddress) && this.getServiceEntityName().equals(anotherO.getServiceEntityName());
    }

    public int hashCode() {
        return Objects.hashCode(this.mAddress, this.mServiceEntityName);
    }

    @Override
    public void serialize(DataOutputStream dos) throws IOException {
        super.serialize(dos);
        dos.writeInt(this.mState.ordinal());
        byte[] serializedArr = GrpcUtils.toProto(this.mAddress).toByteArray();
        dos.writeInt(serializedArr.length);
        dos.write(serializedArr);
    }

    @Override
    public void deserialize(DataInputStream dis) throws IOException {
        super.deserialize(dis);
        this.mState = State.values()[dis.readInt()];
        int byteArrLen = dis.readInt();
        byte[] byteArr = new byte[byteArrLen];
        dis.read(byteArr, 0, byteArrLen);
        this.mAddress = GrpcUtils.fromProto(alluxio.grpc.WorkerNetAddress.parseFrom(byteArr));
    }

    static enum State {
        JOINED,
        AUTHORIZED,
        DECOMMISSIONED;

    }
}

