/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.vertx.core.http;

import alluxio.shaded.client.io.vertx.codegen.annotations.CacheReturn;
import alluxio.shaded.client.io.vertx.codegen.annotations.Fluent;
import alluxio.shaded.client.io.vertx.codegen.annotations.GenIgnore;
import alluxio.shaded.client.io.vertx.codegen.annotations.Nullable;
import alluxio.shaded.client.io.vertx.codegen.annotations.VertxGen;
import alluxio.shaded.client.io.vertx.core.AsyncResult;
import alluxio.shaded.client.io.vertx.core.Future;
import alluxio.shaded.client.io.vertx.core.Handler;
import alluxio.shaded.client.io.vertx.core.MultiMap;
import alluxio.shaded.client.io.vertx.core.buffer.Buffer;
import alluxio.shaded.client.io.vertx.core.http.HttpClientResponse;
import alluxio.shaded.client.io.vertx.core.http.HttpConnection;
import alluxio.shaded.client.io.vertx.core.http.HttpFrame;
import alluxio.shaded.client.io.vertx.core.http.HttpHeaders;
import alluxio.shaded.client.io.vertx.core.http.HttpMethod;
import alluxio.shaded.client.io.vertx.core.http.HttpVersion;
import alluxio.shaded.client.io.vertx.core.http.StreamPriority;
import alluxio.shaded.client.io.vertx.core.streams.ReadStream;
import alluxio.shaded.client.io.vertx.core.streams.WriteStream;

@VertxGen
public interface HttpClientRequest
extends WriteStream<Buffer> {
    @Override
    public HttpClientRequest exceptionHandler(Handler<Throwable> var1);

    public HttpClientRequest setWriteQueueMaxSize(int var1);

    public HttpClientRequest drainHandler(Handler<Void> var1);

    @Fluent
    public HttpClientRequest setHost(String var1);

    public String getHost();

    @Fluent
    public HttpClientRequest setPort(int var1);

    public int getPort();

    @Fluent
    public HttpClientRequest setFollowRedirects(boolean var1);

    @Fluent
    public HttpClientRequest setMaxRedirects(int var1);

    @Fluent
    public HttpClientRequest setChunked(boolean var1);

    public boolean isChunked();

    public HttpMethod getMethod();

    @Fluent
    public HttpClientRequest setMethod(HttpMethod var1);

    public String absoluteURI();

    public String getURI();

    @Fluent
    public HttpClientRequest setURI(String var1);

    public String path();

    public String query();

    @CacheReturn
    public MultiMap headers();

    @Fluent
    public HttpClientRequest putHeader(String var1, String var2);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public HttpClientRequest putHeader(CharSequence var1, CharSequence var2);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public HttpClientRequest putHeader(String var1, Iterable<String> var2);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public HttpClientRequest putHeader(CharSequence var1, Iterable<CharSequence> var2);

    public HttpVersion version();

    @Override
    public Future<Void> write(String var1);

    @Override
    public void write(String var1, Handler<AsyncResult<Void>> var2);

    public Future<Void> write(String var1, String var2);

    public void write(String var1, String var2, Handler<AsyncResult<Void>> var3);

    @Fluent
    public HttpClientRequest continueHandler(@Nullable Handler<Void> var1);

    public Future<Void> sendHead();

    @Fluent
    public HttpClientRequest sendHead(Handler<AsyncResult<Void>> var1);

    public void connect(Handler<AsyncResult<HttpClientResponse>> var1);

    public Future<HttpClientResponse> connect();

    @Fluent
    public HttpClientRequest response(Handler<AsyncResult<HttpClientResponse>> var1);

    public Future<HttpClientResponse> response();

    default public void send(Handler<AsyncResult<HttpClientResponse>> handler) {
        this.response(handler);
        this.end();
    }

    default public Future<HttpClientResponse> send() {
        this.end();
        return this.response();
    }

    default public void send(String body, Handler<AsyncResult<HttpClientResponse>> handler) {
        this.response(handler);
        this.end(body);
    }

    default public Future<HttpClientResponse> send(String body) {
        this.end(body);
        return this.response();
    }

    default public void send(Buffer body, Handler<AsyncResult<HttpClientResponse>> handler) {
        this.response(handler);
        this.end(body);
    }

    default public Future<HttpClientResponse> send(Buffer body) {
        this.end(body);
        return this.response();
    }

    default public void send(ReadStream<Buffer> body, Handler<AsyncResult<HttpClientResponse>> handler) {
        MultiMap headers = this.headers();
        if (headers == null || !headers.contains(HttpHeaders.CONTENT_LENGTH)) {
            this.setChunked(true);
        }
        this.response(handler);
        body.pipeTo(this);
    }

    default public Future<HttpClientResponse> send(ReadStream<Buffer> body) {
        MultiMap headers = this.headers();
        if (headers == null || !headers.contains(HttpHeaders.CONTENT_LENGTH)) {
            this.setChunked(true);
        }
        body.pipeTo(this);
        return this.response();
    }

    @Override
    public Future<Void> end(String var1);

    @Override
    public void end(String var1, Handler<AsyncResult<Void>> var2);

    public Future<Void> end(String var1, String var2);

    public void end(String var1, String var2, Handler<AsyncResult<Void>> var3);

    @Override
    public Future<Void> end(Buffer var1);

    @Override
    public void end(Buffer var1, Handler<AsyncResult<Void>> var2);

    @Override
    public Future<Void> end();

    @Override
    public void end(Handler<AsyncResult<Void>> var1);

    @Fluent
    public HttpClientRequest setTimeout(long var1);

    @Fluent
    public HttpClientRequest pushHandler(Handler<HttpClientRequest> var1);

    default public boolean reset() {
        return this.reset(0L);
    }

    public boolean reset(long var1);

    public boolean reset(long var1, Throwable var3);

    @CacheReturn
    public HttpConnection connection();

    @Fluent
    public HttpClientRequest writeCustomFrame(int var1, int var2, Buffer var3);

    default public int streamId() {
        return -1;
    }

    @Fluent
    default public HttpClientRequest writeCustomFrame(HttpFrame frame) {
        return this.writeCustomFrame(frame.type(), frame.flags(), frame.payload());
    }

    @Fluent
    default public HttpClientRequest setStreamPriority(StreamPriority streamPriority) {
        return this;
    }

    public StreamPriority getStreamPriority();
}

