package alluxio.shaded.client.io.etcd.jetcd.api;

import static alluxio.shaded.client.io.etcd.jetcd.api.ClusterGrpc.getServiceDescriptor;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncBidiStreamingCall;


@alluxio.shaded.client.javax.annotation.Generated(
value = "by VertxGrpc generator",
alluxio.shaded.client.com.ents = "Source: rpc.proto")
public final class VertxClusterGrpc {
    private VertxClusterGrpc() {}

    public static ClusterVertxStub newVertxStub(alluxio.shaded.client.io.grpc.Channel channel) {
        return new ClusterVertxStub(channel);
    }

    
    public static final class ClusterVertxStub extends alluxio.shaded.client.io.grpc.stub.AbstractStub<ClusterVertxStub> {
        private final alluxio.shaded.client.io.vertx.core.impl.ContextInternal ctx;
        private ClusterGrpc.ClusterStub delegateStub;

        private ClusterVertxStub(alluxio.shaded.client.io.grpc.Channel channel) {
            super(channel);
            delegateStub = ClusterGrpc.newStub(channel);
            this.ctx = (alluxio.shaded.client.io.vertx.core.impl.ContextInternal) alluxio.shaded.client.io.vertx.core.Vertx.currentContext();
        }

        private ClusterVertxStub(alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
            super(channel, callOptions);
            delegateStub = ClusterGrpc.newStub(channel).build(channel, callOptions);
            this.ctx = (alluxio.shaded.client.io.vertx.core.impl.ContextInternal) alluxio.shaded.client.io.vertx.core.Vertx.currentContext();
        }

        @Override
        protected ClusterVertxStub build(alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
            return new ClusterVertxStub(channel, callOptions);
        }

        /**
         * <pre>
         *  Range gets the keys in the range from the key-value store.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.MemberAddResponse> memberAdd(alluxio.shaded.client.io.etcd.jetcd.api.MemberAddRequest request) {
            return alluxio.shaded.client.io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::memberAdd);
        }

        /**
         * <pre>
         *  Put puts the given key into the key-value store.
         *  A put request increments the revision of the key-value store
         *  and generates one event in the event history.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.MemberRemoveResponse> memberRemove(alluxio.shaded.client.io.etcd.jetcd.api.MemberRemoveRequest request) {
            return alluxio.shaded.client.io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::memberRemove);
        }

        /**
         * <pre>
         *  DeleteRange deletes the given range from the key-value store.
         *  A delete request increments the revision of the key-value store
         *  and generates a delete event in the event history for every deleted key.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.MemberUpdateResponse> memberUpdate(alluxio.shaded.client.io.etcd.jetcd.api.MemberUpdateRequest request) {
            return alluxio.shaded.client.io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::memberUpdate);
        }

        /**
         * <pre>
         *  Txn processes multiple requests in a single transaction.
         *  A txn request increments the revision of the key-value store
         *  and generates events with the same revision for every alluxio.shaded.client.com.leted request.
         *  It is not allowed to modify the same key several times within one txn.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.MemberListResponse> memberList(alluxio.shaded.client.io.etcd.jetcd.api.MemberListRequest request) {
            return alluxio.shaded.client.io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::memberList);
        }

    }

    
    public static abstract class ClusterVertxImplBase implements alluxio.shaded.client.io.grpc.BindableService {
        private String alluxio.shaded.client.com.ression;

        /**
         * Set whether the server will try to use a alluxio.shaded.client.com.ressed response.
         *
         * @param alluxio.shaded.client.com.ression the alluxio.shaded.client.com.ression, e.g {@code gzip}
         */
        public ClusterVertxImplBase withCompression(String alluxio.shaded.client.com.ression) {
            this.alluxio.shaded.client.com.ression = alluxio.shaded.client.com.ression;
            return this;
        }

        /**
         * <pre>
         *  Range gets the keys in the range from the key-value store.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.MemberAddResponse> memberAdd(alluxio.shaded.client.io.etcd.jetcd.api.MemberAddRequest request) {
            throw new alluxio.shaded.client.io.grpc.StatusRuntimeException(alluxio.shaded.client.io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Put puts the given key into the key-value store.
         *  A put request increments the revision of the key-value store
         *  and generates one event in the event history.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.MemberRemoveResponse> memberRemove(alluxio.shaded.client.io.etcd.jetcd.api.MemberRemoveRequest request) {
            throw new alluxio.shaded.client.io.grpc.StatusRuntimeException(alluxio.shaded.client.io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  DeleteRange deletes the given range from the key-value store.
         *  A delete request increments the revision of the key-value store
         *  and generates a delete event in the event history for every deleted key.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.MemberUpdateResponse> memberUpdate(alluxio.shaded.client.io.etcd.jetcd.api.MemberUpdateRequest request) {
            throw new alluxio.shaded.client.io.grpc.StatusRuntimeException(alluxio.shaded.client.io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Txn processes multiple requests in a single transaction.
         *  A txn request increments the revision of the key-value store
         *  and generates events with the same revision for every alluxio.shaded.client.com.leted request.
         *  It is not allowed to modify the same key several times within one txn.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.MemberListResponse> memberList(alluxio.shaded.client.io.etcd.jetcd.api.MemberListRequest request) {
            throw new alluxio.shaded.client.io.grpc.StatusRuntimeException(alluxio.shaded.client.io.grpc.Status.UNIMPLEMENTED);
        }

        @java.lang.Override public final alluxio.shaded.client.io.grpc.ServerServiceDefinition bindService() {
            return alluxio.shaded.client.io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
                    .addMethod(
                            alluxio.shaded.client.io.etcd.jetcd.api.ClusterGrpc.getMemberAddMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            alluxio.shaded.client.io.etcd.jetcd.api.MemberAddRequest,
                                            alluxio.shaded.client.io.etcd.jetcd.api.MemberAddResponse>(
                                            this, METHODID_MEMBER_ADD, alluxio.shaded.client.com.ression)))
                    .addMethod(
                            alluxio.shaded.client.io.etcd.jetcd.api.ClusterGrpc.getMemberRemoveMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            alluxio.shaded.client.io.etcd.jetcd.api.MemberRemoveRequest,
                                            alluxio.shaded.client.io.etcd.jetcd.api.MemberRemoveResponse>(
                                            this, METHODID_MEMBER_REMOVE, alluxio.shaded.client.com.ression)))
                    .addMethod(
                            alluxio.shaded.client.io.etcd.jetcd.api.ClusterGrpc.getMemberUpdateMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            alluxio.shaded.client.io.etcd.jetcd.api.MemberUpdateRequest,
                                            alluxio.shaded.client.io.etcd.jetcd.api.MemberUpdateResponse>(
                                            this, METHODID_MEMBER_UPDATE, alluxio.shaded.client.com.ression)))
                    .addMethod(
                            alluxio.shaded.client.io.etcd.jetcd.api.ClusterGrpc.getMemberListMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            alluxio.shaded.client.io.etcd.jetcd.api.MemberListRequest,
                                            alluxio.shaded.client.io.etcd.jetcd.api.MemberListResponse>(
                                            this, METHODID_MEMBER_LIST, alluxio.shaded.client.com.ression)))
                    .build();
        }
    }

    private static final int METHODID_MEMBER_ADD = 0;
    private static final int METHODID_MEMBER_REMOVE = 1;
    private static final int METHODID_MEMBER_UPDATE = 2;
    private static final int METHODID_MEMBER_LIST = 3;

    private static final class MethodHandlers<Req, Resp> implements
            alluxio.shaded.client.io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
            alluxio.shaded.client.io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
            alluxio.shaded.client.io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
            alluxio.shaded.client.io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {

        private final ClusterVertxImplBase serviceImpl;
        private final int methodId;
        private final String alluxio.shaded.client.com.ression;

        MethodHandlers(ClusterVertxImplBase serviceImpl, int methodId, String alluxio.shaded.client.com.ression) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
            this.alluxio.shaded.client.com.ression = alluxio.shaded.client.com.ression;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("unchecked")
        public void invoke(Req request, alluxio.shaded.client.io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch (methodId) {
                case METHODID_MEMBER_ADD:
                    alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (alluxio.shaded.client.io.etcd.jetcd.api.MemberAddRequest) request,
                            (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.MemberAddResponse>) responseObserver,
                            alluxio.shaded.client.com.ression,
                            serviceImpl::memberAdd);
                    break;
                case METHODID_MEMBER_REMOVE:
                    alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (alluxio.shaded.client.io.etcd.jetcd.api.MemberRemoveRequest) request,
                            (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.MemberRemoveResponse>) responseObserver,
                            alluxio.shaded.client.com.ression,
                            serviceImpl::memberRemove);
                    break;
                case METHODID_MEMBER_UPDATE:
                    alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (alluxio.shaded.client.io.etcd.jetcd.api.MemberUpdateRequest) request,
                            (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.MemberUpdateResponse>) responseObserver,
                            alluxio.shaded.client.com.ression,
                            serviceImpl::memberUpdate);
                    break;
                case METHODID_MEMBER_LIST:
                    alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (alluxio.shaded.client.io.etcd.jetcd.api.MemberListRequest) request,
                            (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.MemberListResponse>) responseObserver,
                            alluxio.shaded.client.com.ression,
                            serviceImpl::memberList);
                    break;
                default:
                    throw new java.lang.AssertionError();
            }
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("unchecked")
        public alluxio.shaded.client.io.grpc.stub.StreamObserver<Req> invoke(alluxio.shaded.client.io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch (methodId) {
                default:
                    throw new java.lang.AssertionError();
            }
        }
    }

}
