package alluxio.shaded.client.io.etcd.jetcd.api.lock;

import static alluxio.shaded.client.io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 * The lock service exposes client-side locking facilities as a gRPC interface.
 * </pre>
 */
@alluxio.shaded.client.javax.annotation.Generated(
    value = "by gRPC proto alluxio.shaded.client.com.iler (version 1.51.0)",
    alluxio.shaded.client.com.ents = "Source: lock.proto")
@alluxio.shaded.client.io.grpc.stub.annotations.GrpcGenerated
public final class LockGrpc {

  private LockGrpc() {}

  public static final String SERVICE_NAME = "v3lockpb.Lock";

  // Static method descriptors that strictly reflect the proto.
  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.shaded.client.io.etcd.jetcd.api.lock.LockRequest,
      alluxio.shaded.client.io.etcd.jetcd.api.lock.LockResponse> getLockMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Lock",
      requestType = alluxio.shaded.client.io.etcd.jetcd.api.lock.LockRequest.class,
      responseType = alluxio.shaded.client.io.etcd.jetcd.api.lock.LockResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.shaded.client.io.etcd.jetcd.api.lock.LockRequest,
      alluxio.shaded.client.io.etcd.jetcd.api.lock.LockResponse> getLockMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.shaded.client.io.etcd.jetcd.api.lock.LockRequest, alluxio.shaded.client.io.etcd.jetcd.api.lock.LockResponse> getLockMethod;
    if ((getLockMethod = LockGrpc.getLockMethod) == null) {
      synchronized (LockGrpc.class) {
        if ((getLockMethod = LockGrpc.getLockMethod) == null) {
          LockGrpc.getLockMethod = getLockMethod =
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.shaded.client.io.etcd.jetcd.api.lock.LockRequest, alluxio.shaded.client.io.etcd.jetcd.api.lock.LockResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Lock"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.shaded.client.io.etcd.jetcd.api.lock.LockRequest.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.shaded.client.io.etcd.jetcd.api.lock.LockResponse.getDefaultInstance()))
              .setSchemaDescriptor(new LockMethodDescriptorSupplier("Lock"))
              .build();
        }
      }
    }
    return getLockMethod;
  }

  private static volatile alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.shaded.client.io.etcd.jetcd.api.lock.UnlockRequest,
      alluxio.shaded.client.io.etcd.jetcd.api.lock.UnlockResponse> getUnlockMethod;

  @alluxio.shaded.client.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Unlock",
      requestType = alluxio.shaded.client.io.etcd.jetcd.api.lock.UnlockRequest.class,
      responseType = alluxio.shaded.client.io.etcd.jetcd.api.lock.UnlockResponse.class,
      methodType = alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
  public static alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.shaded.client.io.etcd.jetcd.api.lock.UnlockRequest,
      alluxio.shaded.client.io.etcd.jetcd.api.lock.UnlockResponse> getUnlockMethod() {
    alluxio.shaded.client.io.grpc.MethodDescriptor<alluxio.shaded.client.io.etcd.jetcd.api.lock.UnlockRequest, alluxio.shaded.client.io.etcd.jetcd.api.lock.UnlockResponse> getUnlockMethod;
    if ((getUnlockMethod = LockGrpc.getUnlockMethod) == null) {
      synchronized (LockGrpc.class) {
        if ((getUnlockMethod = LockGrpc.getUnlockMethod) == null) {
          LockGrpc.getUnlockMethod = getUnlockMethod =
              alluxio.shaded.client.io.grpc.MethodDescriptor.<alluxio.shaded.client.io.etcd.jetcd.api.lock.UnlockRequest, alluxio.shaded.client.io.etcd.jetcd.api.lock.UnlockResponse>newBuilder()
              .setType(alluxio.shaded.client.io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Unlock"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.shaded.client.io.etcd.jetcd.api.lock.UnlockRequest.getDefaultInstance()))
              .setResponseMarshaller(alluxio.shaded.client.io.grpc.protobuf.ProtoUtils.marshaller(
                  alluxio.shaded.client.io.etcd.jetcd.api.lock.UnlockResponse.getDefaultInstance()))
              .setSchemaDescriptor(new LockMethodDescriptorSupplier("Unlock"))
              .build();
        }
      }
    }
    return getUnlockMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static LockStub newStub(alluxio.shaded.client.io.grpc.Channel channel) {
    alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<LockStub> factory =
      new alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<LockStub>() {
        @java.lang.Override
        public LockStub newStub(alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
          return new LockStub(channel, callOptions);
        }
      };
    return LockStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static LockBlockingStub newBlockingStub(
      alluxio.shaded.client.io.grpc.Channel channel) {
    alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<LockBlockingStub> factory =
      new alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<LockBlockingStub>() {
        @java.lang.Override
        public LockBlockingStub newStub(alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
          return new LockBlockingStub(channel, callOptions);
        }
      };
    return LockBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static LockFutureStub newFutureStub(
      alluxio.shaded.client.io.grpc.Channel channel) {
    alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<LockFutureStub> factory =
      new alluxio.shaded.client.io.grpc.stub.AbstractStub.StubFactory<LockFutureStub>() {
        @java.lang.Override
        public LockFutureStub newStub(alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
          return new LockFutureStub(channel, callOptions);
        }
      };
    return LockFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   * The lock service exposes client-side locking facilities as a gRPC interface.
   * </pre>
   */
  public static abstract class LockImplBase implements alluxio.shaded.client.io.grpc.BindableService {

    /**
     * <pre>
     * Lock acquires a distributed shared lock on a given named lock.
     * On success, it will return a unique key that exists so long as the
     * lock is held by the caller. This key can be used in conjunction with
     * transactions to safely ensure updates to etcd only occur while holding
     * lock ownership. The lock is held until Unlock is called on the key or the
     * lease associate with the owner expires.
     * </pre>
     */
    public void lock(alluxio.shaded.client.io.etcd.jetcd.api.lock.LockRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.lock.LockResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getLockMethod(), responseObserver);
    }

    /**
     * <pre>
     * Unlock takes a key returned by Lock and releases the hold on lock. The
     * next Lock caller waiting for the lock will then be woken up and given
     * ownership of the lock.
     * </pre>
     */
    public void unlock(alluxio.shaded.client.io.etcd.jetcd.api.lock.UnlockRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.lock.UnlockResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getUnlockMethod(), responseObserver);
    }

    @java.lang.Override public final alluxio.shaded.client.io.grpc.ServerServiceDefinition bindService() {
      return alluxio.shaded.client.io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getLockMethod(),
            alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                alluxio.shaded.client.io.etcd.jetcd.api.lock.LockRequest,
                alluxio.shaded.client.io.etcd.jetcd.api.lock.LockResponse>(
                  this, METHODID_LOCK)))
          .addMethod(
            getUnlockMethod(),
            alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall(
              new MethodHandlers<
                alluxio.shaded.client.io.etcd.jetcd.api.lock.UnlockRequest,
                alluxio.shaded.client.io.etcd.jetcd.api.lock.UnlockResponse>(
                  this, METHODID_UNLOCK)))
          .build();
    }
  }

  /**
   * <pre>
   * The lock service exposes client-side locking facilities as a gRPC interface.
   * </pre>
   */
  public static final class LockStub extends alluxio.shaded.client.io.grpc.stub.AbstractAsyncStub<LockStub> {
    private LockStub(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected LockStub build(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      return new LockStub(channel, callOptions);
    }

    /**
     * <pre>
     * Lock acquires a distributed shared lock on a given named lock.
     * On success, it will return a unique key that exists so long as the
     * lock is held by the caller. This key can be used in conjunction with
     * transactions to safely ensure updates to etcd only occur while holding
     * lock ownership. The lock is held until Unlock is called on the key or the
     * lease associate with the owner expires.
     * </pre>
     */
    public void lock(alluxio.shaded.client.io.etcd.jetcd.api.lock.LockRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.lock.LockResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getLockMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Unlock takes a key returned by Lock and releases the hold on lock. The
     * next Lock caller waiting for the lock will then be woken up and given
     * ownership of the lock.
     * </pre>
     */
    public void unlock(alluxio.shaded.client.io.etcd.jetcd.api.lock.UnlockRequest request,
        alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.lock.UnlockResponse> responseObserver) {
      alluxio.shaded.client.io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getUnlockMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * The lock service exposes client-side locking facilities as a gRPC interface.
   * </pre>
   */
  public static final class LockBlockingStub extends alluxio.shaded.client.io.grpc.stub.AbstractBlockingStub<LockBlockingStub> {
    private LockBlockingStub(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected LockBlockingStub build(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      return new LockBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Lock acquires a distributed shared lock on a given named lock.
     * On success, it will return a unique key that exists so long as the
     * lock is held by the caller. This key can be used in conjunction with
     * transactions to safely ensure updates to etcd only occur while holding
     * lock ownership. The lock is held until Unlock is called on the key or the
     * lease associate with the owner expires.
     * </pre>
     */
    public alluxio.shaded.client.io.etcd.jetcd.api.lock.LockResponse lock(alluxio.shaded.client.io.etcd.jetcd.api.lock.LockRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getLockMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Unlock takes a key returned by Lock and releases the hold on lock. The
     * next Lock caller waiting for the lock will then be woken up and given
     * ownership of the lock.
     * </pre>
     */
    public alluxio.shaded.client.io.etcd.jetcd.api.lock.UnlockResponse unlock(alluxio.shaded.client.io.etcd.jetcd.api.lock.UnlockRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getUnlockMethod(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * The lock service exposes client-side locking facilities as a gRPC interface.
   * </pre>
   */
  public static final class LockFutureStub extends alluxio.shaded.client.io.grpc.stub.AbstractFutureStub<LockFutureStub> {
    private LockFutureStub(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected LockFutureStub build(
        alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
      return new LockFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Lock acquires a distributed shared lock on a given named lock.
     * On success, it will return a unique key that exists so long as the
     * lock is held by the caller. This key can be used in conjunction with
     * transactions to safely ensure updates to etcd only occur while holding
     * lock ownership. The lock is held until Unlock is called on the key or the
     * lease associate with the owner expires.
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.shaded.client.io.etcd.jetcd.api.lock.LockResponse> lock(
        alluxio.shaded.client.io.etcd.jetcd.api.lock.LockRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getLockMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Unlock takes a key returned by Lock and releases the hold on lock. The
     * next Lock caller waiting for the lock will then be woken up and given
     * ownership of the lock.
     * </pre>
     */
    public alluxio.shaded.client.com.google.alluxio.shaded.client.com.on.util.concurrent.ListenableFuture<alluxio.shaded.client.io.etcd.jetcd.api.lock.UnlockResponse> unlock(
        alluxio.shaded.client.io.etcd.jetcd.api.lock.UnlockRequest request) {
      return alluxio.shaded.client.io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getUnlockMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_LOCK = 0;
  private static final int METHODID_UNLOCK = 1;

  private static final class MethodHandlers<Req, Resp> implements
      alluxio.shaded.client.io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      alluxio.shaded.client.io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      alluxio.shaded.client.io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      alluxio.shaded.client.io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final LockImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(LockImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, alluxio.shaded.client.io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_LOCK:
          serviceImpl.lock((alluxio.shaded.client.io.etcd.jetcd.api.lock.LockRequest) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.lock.LockResponse>) responseObserver);
          break;
        case METHODID_UNLOCK:
          serviceImpl.unlock((alluxio.shaded.client.io.etcd.jetcd.api.lock.UnlockRequest) request,
              (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.lock.UnlockResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public alluxio.shaded.client.io.grpc.stub.StreamObserver<Req> invoke(
        alluxio.shaded.client.io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class LockBaseDescriptorSupplier
      implements alluxio.shaded.client.io.grpc.protobuf.ProtoFileDescriptorSupplier, alluxio.shaded.client.io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    LockBaseDescriptorSupplier() {}

    @java.lang.Override
    public alluxio.shaded.client.com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return alluxio.shaded.client.io.etcd.jetcd.api.lock.JetcdProto.getDescriptor();
    }

    @java.lang.Override
    public alluxio.shaded.client.com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("Lock");
    }
  }

  private static final class LockFileDescriptorSupplier
      extends LockBaseDescriptorSupplier {
    LockFileDescriptorSupplier() {}
  }

  private static final class LockMethodDescriptorSupplier
      extends LockBaseDescriptorSupplier
      implements alluxio.shaded.client.io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    LockMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public alluxio.shaded.client.com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile alluxio.shaded.client.io.grpc.ServiceDescriptor serviceDescriptor;

  public static alluxio.shaded.client.io.grpc.ServiceDescriptor getServiceDescriptor() {
    alluxio.shaded.client.io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (LockGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = alluxio.shaded.client.io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new LockFileDescriptorSupplier())
              .addMethod(getLockMethod())
              .addMethod(getUnlockMethod())
              .build();
        }
      }
    }
    return result;
  }
}
