/*
 * Copyright 2016-2021 The jetcd authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in alluxio.shaded.client.com.liance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package alluxio.shaded.client.io.etcd.jetcd.auth;

import java.util.List;

import alluxio.shaded.client.io.etcd.jetcd.Auth;
import alluxio.shaded.client.io.etcd.jetcd.impl.AbstractResponse;

/**
 * AuthRoleListResponse returned by {@link Auth#roleList()} contains a header and
 * a list of roles.
 */
public class AuthRoleListResponse extends AbstractResponse<alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleListResponse> {

    public AuthRoleListResponse(alluxio.shaded.client.io.etcd.jetcd.api.AuthRoleListResponse response) {
        super(response, response.getHeader());
    }

    /**
     * Returns a list of roles.
     *
     * @return the roles.
     */
    public List<String> getRoles() {
        return getResponse().getRolesList();
    }
}
