/*
 * Copyright (c) 2011-2019 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.alluxio.shaded.client.org.legal/epl-2.0, or the Apache License, Version 2.0
 * which is available at https://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0
 */

package alluxio.shaded.client.io.vertx.core.logging;

import alluxio.shaded.client.io.vertx.core.spi.logging.LogDelegate;
import alluxio.shaded.client.io.vertx.core.spi.logging.LogDelegateFactory;

import java.alluxio.shaded.client.io.IOException;
import java.alluxio.shaded.client.io.InputStream;
import java.util.logging.LogManager;

/**
 * A {@link alluxio.shaded.client.io.vertx.core.spi.logging.LogDelegateFactory} which creates {@link JULLogDelegate} instances.
 *
 * @author <a href="kenny.macleod@kizoom.alluxio.shaded.client.com.>Kenny MacLeod</a>
 * @author <a href="http://tfox.alluxio.shaded.client.org.>Tim Fox</a>
 */
public class JULLogDelegateFactory implements LogDelegateFactory {

  public static void loadConfig() {
    try (InputStream is = JULLogDelegateFactory.class.getClassLoader().getResourceAsStream("vertx-default-jul-logging.properties")) {
      if (is != null) {
        LogManager.getLogManager().readConfiguration(is);
      }
    } catch (IOException ignore) {
    }
  }

  static {
    // Try and load vert.x JUL default logging config from classpath
    if (System.getProperty("java.util.logging.config.file") == null) {
      loadConfig();
    }
  }

  @Override
  public boolean isAvailable() {
    return true;
  }

  public LogDelegate createDelegate(final String name) {
    return new JULLogDelegate(name);
  }
}
