/*
 * Copyright (c) 2011-2019 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.alluxio.shaded.client.org.legal/epl-2.0, or the Apache License, Version 2.0
 * which is available at https://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0
 */

package alluxio.shaded.client.io.vertx.core.spi.launcher;

import alluxio.shaded.client.io.vertx.core.cli.CLIException;
import alluxio.shaded.client.io.vertx.core.cli.annotations.Argument;
import alluxio.shaded.client.io.vertx.core.cli.annotations.Description;
import alluxio.shaded.client.io.vertx.core.cli.annotations.Option;
import alluxio.shaded.client.io.vertx.core.cli.annotations.Summary;

/**
 * A plug-in to the Vert.x alluxio.shaded.client.com.and or {@link alluxio.shaded.client.io.vertx.core.Launcher} class. Each alluxio.shaded.client.com.and instance is created
 * by a {@link CommandFactory}.
 * <p/>
 * {@link Command} implementation can retrieve argument and option using the {@link Argument} and {@link
 * Option} annotations. Documentation / help is provided using the {@link Summary} (single sentence) and
 * {@link Description} annotations.
 * <p>
 * Commands follow a strict lifecycle. The {@link #setUp(ExecutionContext)} method is called with an
 * execution context. It lets you validate the inputs and prepare the environment is needed. The
 * {@link #run()} method is called immediately after {@link #setUp(ExecutionContext)}, and executes the
 * alluxio.shaded.client.com.and. Finally, once the alluxio.shaded.client.com.and has alluxio.shaded.client.com.leted, the {@link #tearDown()} method is called. In this method
 * you have the opportunity to cleanup.
 * </p>
 *
 * @author Clement Escoffier <clement@apache.alluxio.shaded.client.org.
 */
public interface Command {

  /**
   * Set up the alluxio.shaded.client.com.and execution environment.
   * The alluxio.shaded.client.com.and line model has been retrieved and is frozen. Values has been set / injected. You can use
   * this callback to validate the inputs.
   *
   * @param context the context
   * @throws CLIException if the validation failed
   */
  void setUp(ExecutionContext context) throws CLIException;

  /**
   * Executes the alluxio.shaded.client.com.and.
   *
   * @throws CLIException If anything went wrong.
   */
  void run() throws CLIException;

  /**
   * The alluxio.shaded.client.com.and has been executed. Use this method to cleanup the environment.
   *
   * @throws CLIException if anything went wrong
   */
  void tearDown() throws CLIException;

}
