/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache;

import alluxio.client.file.cache.PageId;
import alluxio.client.file.cache.PageStore;
import alluxio.client.file.cache.store.PageStoreOptions;
import alluxio.exception.PageNotFoundException;
import alluxio.exception.status.ResourceExhaustedException;
import alluxio.file.ReadTargetBuffer;
import alluxio.metrics.MetricKey;
import alluxio.metrics.MetricsSystem;
import alluxio.network.protocol.databuffer.DataFileChannel;
import alluxio.shaded.client.com.codahale.metrics.Counter;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.com.google.common.base.Throwables;
import alluxio.shaded.client.com.google.common.util.concurrent.SimpleTimeLimiter;
import alluxio.shaded.client.com.google.common.util.concurrent.TimeLimiter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TimeBoundPageStore
implements PageStore {
    private final PageStore mPageStore;
    private final long mTimeoutMs;
    private final TimeLimiter mTimeLimter;
    private final ExecutorService mExecutorService;

    public TimeBoundPageStore(PageStore pageStore, PageStoreOptions options) {
        this.mPageStore = Preconditions.checkNotNull(pageStore, "pageStore");
        this.mTimeoutMs = options.getTimeoutDuration();
        this.mExecutorService = new ThreadPoolExecutor(options.getTimeoutThreads(), options.getTimeoutThreads(), 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>());
        this.mTimeLimter = SimpleTimeLimiter.create(this.mExecutorService);
    }

    @Override
    public void put(PageId pageId, ByteBuffer page, boolean isTemporary) throws IOException {
        Callable<Void> callable = () -> {
            this.mPageStore.put(pageId, page, isTemporary);
            return null;
        };
        try {
            this.mTimeLimter.callWithTimeout(callable, this.mTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            Metrics.STORE_PUT_TIMEOUT.inc();
            throw new IOException(e);
        }
        catch (RejectedExecutionException e) {
            Metrics.STORE_THREADS_REJECTED.inc();
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible(e.getCause(), ResourceExhaustedException.class, IOException.class);
            throw new IOException(e);
        }
        catch (Throwable t) {
            Throwables.propagateIfPossible(t, IOException.class);
            throw new IOException(t);
        }
    }

    @Override
    public int get(PageId pageId, int pageOffset, int bytesToRead, ReadTargetBuffer target, boolean isTemporary) throws IOException, PageNotFoundException {
        Callable<Integer> callable = () -> this.mPageStore.get(pageId, pageOffset, bytesToRead, target, isTemporary);
        try {
            return this.mTimeLimter.callWithTimeout(callable, this.mTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            Metrics.STORE_GET_TIMEOUT.inc();
            throw new IOException(e);
        }
        catch (RejectedExecutionException e) {
            Metrics.STORE_THREADS_REJECTED.inc();
            throw new IOException(e);
        }
        catch (Throwable t) {
            Throwables.propagateIfPossible(t, IOException.class, PageNotFoundException.class);
            throw new IOException(t);
        }
    }

    @Override
    public void delete(PageId pageId) throws IOException, PageNotFoundException {
        Callable<Void> callable = () -> {
            this.mPageStore.delete(pageId);
            return null;
        };
        try {
            this.mTimeLimter.callWithTimeout(callable, this.mTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            Metrics.STORE_DELETE_TIMEOUT.inc();
            throw new IOException(e);
        }
        catch (RejectedExecutionException e) {
            Metrics.STORE_THREADS_REJECTED.inc();
            throw new IOException(e);
        }
        catch (Throwable t) {
            Throwables.propagateIfPossible(t, IOException.class, PageNotFoundException.class);
            throw new IOException(t);
        }
    }

    @Override
    public DataFileChannel getDataFileChannel(PageId pageId, int pageOffset, int bytesToRead, boolean isTemporary) throws PageNotFoundException {
        return this.mPageStore.getDataFileChannel(pageId, pageOffset, bytesToRead, isTemporary);
    }

    @Override
    public void close() throws Exception {
        this.mExecutorService.shutdown();
        this.mPageStore.close();
    }

    private static final class Metrics {
        private static final Counter STORE_DELETE_TIMEOUT = MetricsSystem.counter(MetricKey.CLIENT_CACHE_STORE_DELETE_TIMEOUT.getName());
        private static final Counter STORE_GET_TIMEOUT = MetricsSystem.counter(MetricKey.CLIENT_CACHE_STORE_GET_TIMEOUT.getName());
        private static final Counter STORE_PUT_TIMEOUT = MetricsSystem.counter(MetricKey.CLIENT_CACHE_STORE_PUT_TIMEOUT.getName());
        private static final Counter STORE_THREADS_REJECTED = MetricsSystem.counter(MetricKey.CLIENT_CACHE_STORE_THREADS_REJECTED.getName());

        private Metrics() {
        }
    }
}

