/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache.store;

import alluxio.client.file.cache.PageId;
import alluxio.client.file.cache.PageStore;
import alluxio.exception.PageNotFoundException;
import alluxio.file.ReadTargetBuffer;
import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;

@NotThreadSafe
public class MemoryPageStore
implements PageStore {
    private final PagePool mPagePool;
    private ConcurrentHashMap<PageId, MemPage> mPageStoreMap = new ConcurrentHashMap();

    public MemoryPageStore(int pageSize) {
        this.mPagePool = new PagePool(pageSize);
    }

    @Override
    public void put(PageId pageId, ByteBuffer page, boolean isTemporary) throws IOException {
        PageId pageKey = this.getKeyFromPageId(pageId);
        try {
            MemPage pageCopy = this.mPagePool.acquire(page.remaining());
            page.get(pageCopy.getPage(), 0, pageCopy.getPageLength());
            this.mPageStoreMap.put(pageKey, pageCopy);
        }
        catch (Exception e) {
            throw new IOException("Failed to put cached data in memory for page " + pageId);
        }
    }

    @Override
    public int get(PageId pageId, int pageOffset, int bytesToRead, ReadTargetBuffer target, boolean isTemporary) throws IOException, PageNotFoundException {
        Preconditions.checkArgument(target != null, "buffer is null");
        Preconditions.checkArgument(pageOffset >= 0, "page offset should be non-negative");
        PageId pageKey = this.getKeyFromPageId(pageId);
        if (!this.mPageStoreMap.containsKey(pageKey)) {
            throw new PageNotFoundException(pageId.getFileId() + "_" + pageId.getPageIndex());
        }
        MemPage page = this.mPageStoreMap.get(pageKey);
        Preconditions.checkArgument(pageOffset <= page.getPageLength(), "page offset %s exceeded page size %s", pageOffset, page.getPageLength());
        int bytesLeft = (int)Math.min((long)(page.getPageLength() - pageOffset), target.remaining());
        bytesLeft = Math.min(bytesLeft, bytesToRead);
        target.writeBytes(page.getPage(), pageOffset, bytesLeft);
        return bytesLeft;
    }

    @Override
    public void delete(PageId pageId) throws IOException, PageNotFoundException {
        PageId pageKey = this.getKeyFromPageId(pageId);
        if (!this.mPageStoreMap.containsKey(pageKey)) {
            throw new PageNotFoundException(pageId.getFileId() + "_" + pageId.getPageIndex());
        }
        this.mPagePool.release(this.mPageStoreMap.get(pageKey));
        this.mPageStoreMap.remove(pageKey);
    }

    @VisibleForTesting
    public PageId getKeyFromPageId(PageId pageId) {
        return pageId;
    }

    @Override
    public void close() {
        this.mPageStoreMap.clear();
        this.mPageStoreMap = null;
    }

    public void reset() {
        this.mPageStoreMap.clear();
    }

    private static class PagePool {
        private final int mPageSize;
        private final LinkedList<MemPage> mPool = new LinkedList();

        public PagePool(int pageSize) {
            this.mPageSize = pageSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MemPage acquire(int pageLength) {
            LinkedList<MemPage> linkedList = this.mPool;
            synchronized (linkedList) {
                if (!this.mPool.isEmpty()) {
                    MemPage page = this.mPool.pop();
                    page.setPageLength(pageLength);
                    return page;
                }
            }
            return new MemPage(new byte[this.mPageSize], pageLength);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release(MemPage page) {
            LinkedList<MemPage> linkedList = this.mPool;
            synchronized (linkedList) {
                this.mPool.push(page);
            }
        }
    }

    private static class MemPage {
        private final byte[] mPage;
        private int mPageLength;

        public MemPage(byte[] page, int pageLength) {
            this.mPage = page;
            this.mPageLength = pageLength;
        }

        public byte[] getPage() {
            return this.mPage;
        }

        public int getPageLength() {
            return this.mPageLength;
        }

        public void setPageLength(int pageLength) {
            this.mPageLength = pageLength;
        }
    }
}

